/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import com.teamscale.core.user.User;

public class CachedUser {
    private static final long CACHE_VALIDITY_SECONDS = 60L;
    private final User user;
    private long lastAccessTime;

    public CachedUser(User user) {
        this.user = user;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean isValid() {
        return System.currentTimeMillis() - this.lastAccessTime < 60000L;
    }

    public User access() {
        this.lastAccessTime = System.currentTimeMillis();
        return this.user;
    }

    public String getUsernameWithoutAccess() {
        return this.user.getUsername();
    }
}

