/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;

public abstract class AuthenticationToolSynchronizeTriggerAutoBase
extends OptionScheduledTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void execute() throws StorageException {
        try {
            this.synchronize();
        }
        catch (AuthenticationToolException e) {
            LOGGER.error("Failed to synchronize with " + String.valueOf((Object)this.getToolProvider().getAuthenticationTool()) + " server " + this.getServerName() + ": " + e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }

    protected String getServerName() {
        String parameter = this.jobDescriptor.getParameter();
        CCSMAssert.isNotNull((Object)parameter, (String)"Trigger was not scheduled by an option!");
        Pair<String, String> nameAndSelector = OptionRegistryBase.extractOptionNameAndSelector(parameter);
        return (String)nameAndSelector.getSecond();
    }

    protected final IAuthenticationToolProvider getToolProvider() throws StorageException {
        return this.getToolProvider(this.indexLayer.openGlobalStorageSystem());
    }

    protected abstract IAuthenticationToolProvider getToolProvider(GlobalStorageSystem var1);

    protected void synchronize() throws AuthenticationToolException, StorageException {
        this.synchronizeAllGroupsAndUsers();
    }

    protected void synchronizeAllGroupsAndUsers() throws AuthenticationToolException, StorageException {
        ISynchronizeGroupsStrategy strategy = this.getToolProvider().createSynchronizeGroupsStrategy(this.getServerName());
        strategy.synchronizeAllGroupsNow();
        this.synchronizeUsersWithoutRemoteGroup();
    }

    private void synchronizeUsersWithoutRemoteGroup() throws StorageException, AuthenticationToolException {
        ISynchronizeUsersStrategy strategy = this.getToolProvider().createSynchronizeUsersStrategy(this.getServerName());
        UserGroupIndex groupIndex = this.indexLayer.openGlobalIndex(UserGroupIndex.class);
        List<User> users = AuthenticationToolSynchronizeTriggerAutoBase.getUsersWithoutGroup(groupIndex, strategy.getUsersForServer());
        strategy.synchronizeUsers(users);
    }

    private static List<User> getUsersWithoutGroup(UserGroupIndex groupIndex, List<User> users) throws StorageException {
        ArrayList<User> filteredUsers = new ArrayList<User>();
        for (User user : users) {
            if (AuthenticationToolSynchronizeTriggerAutoBase.hasRemoteGroup(groupIndex, user)) continue;
            filteredUsers.add(user);
        }
        return filteredUsers;
    }

    private static boolean hasRemoteGroup(UserGroupIndex groupIndex, User user) throws StorageException {
        return groupIndex.getGroupsForUser(user).stream().anyMatch(group -> group.getRemoteGroup() != null);
    }
}

