/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.GitHubUtils;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class GitHubAppUtils {
    public static List<GitHubApplicationDescription> loadAllConfiguredApplications(ServerOptionIndex optionIndex) throws StorageException {
        return CollectionUtils.map(ServerOptionRegistry.getServerMultiOptionAll(ESsoAuthenticatorType.GITHUB.getOptionId(), optionIndex).values(), appDescription -> (GitHubApplicationDescription)appDescription);
    }

    public static <X extends Exception> @Nullable GitHubApplicationDescription loadConfiguredApplication(String appId, String serverUrl, ServerOptionIndex optionIndex, Function<String, X> exceptionFactory) throws X, StorageException {
        List<GitHubApplicationDescription> availableAppDescriptions = GitHubAppUtils.loadAllConfiguredApplications(optionIndex);
        for (GitHubApplicationDescription appDescription : availableAppDescriptions) {
            if (!appDescription.appId.equals(appId) || !serverUrl.isEmpty() && !GitHubUtils.areGitHubUrlsEqual(appDescription.serverUrl, serverUrl)) continue;
            return GitHubAppUtils.validateApplicationDescription(appDescription, exceptionFactory);
        }
        throw new StorageException("Failed to load GitHub app because there is no GitHub app with id " + appId + " for URL " + serverUrl + ".");
    }

    private static <X extends Exception> @Nullable GitHubApplicationDescription validateApplicationDescription(GitHubApplicationDescription applicationDescription, Function<String, X> exceptionFactory) throws X {
        if (applicationDescription == null) {
            GitHubAppUtils.reportConfigurationError(exceptionFactory, "");
            return null;
        }
        Optional<String> optionalConfigurationCheckMessage = applicationDescription.validateApplication();
        if (optionalConfigurationCheckMessage.isPresent()) {
            GitHubAppUtils.reportConfigurationError(exceptionFactory, optionalConfigurationCheckMessage.get());
            return null;
        }
        return applicationDescription;
    }

    private static <X extends Exception> void reportConfigurationError(Function<String, X> exceptionFactory, String detailError) throws X {
        if (exceptionFactory != null) {
            throw (Exception)exceptionFactory.apply("GitHub integration not configured. Configure GitHub support at Admin > Settings > Github Integration. " + detailError);
        }
    }

    private GitHubAppUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

