/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.client.GitHubAppClient;
import com.teamscale.core.authenticate.github.dto.App;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NullMarked;

@NullMarked
class GitHubApplicationValidator {
    static final String INSECURE_CONFIGURATION_MESSAGE = "\nSetting a 'Default groups for imported users' without specifying any 'Allowed Organizations for SSO' can create a security vulnerability. If your GitHub app is available to other organizations, a user from an unauthorized organization could install the app on their organization and gain access to your Teamscale instance via SSO. They would be assigned to the default group, potentially giving them access to projects on Teamscale which they would usually not have access to on GitHub. To mitigate this risk, it is recommended to simply enter allowed organization names (as in the URL) in the 'Allowed Organizations for SSO' field.";
    private static final Map<String, Integer> PROTOCOL_TO_PORT = CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)"http", (Object)80), Pair.createPair((Object)"https", (Object)443)});
    private final GitHubApplicationDescription gitHubApplicationDescription;

    public GitHubApplicationValidator(GitHubApplicationDescription gitHubApplicationDescription) {
        this.gitHubApplicationDescription = gitHubApplicationDescription;
    }

    public Optional<String> validateApplication() {
        String appIdError = "Provide positive integer value for Github Application ID. ";
        try {
            if (StringUtils.isEmpty((String)this.gitHubApplicationDescription.appId) || this.gitHubApplicationDescription.getAppId() <= 0L) {
                return Optional.of(appIdError);
            }
        }
        catch (NumberFormatException e) {
            return Optional.of(appIdError + e.getMessage());
        }
        if (StringUtils.isEmpty((String)this.gitHubApplicationDescription.privateKey)) {
            return Optional.of("Provide value for Private Key");
        }
        if (StringUtils.isEmpty((String)this.gitHubApplicationDescription.clientId)) {
            return Optional.of("Provide value for OAuth client ID");
        }
        if (StringUtils.isEmpty((String)this.gitHubApplicationDescription.clientSecret)) {
            return Optional.of("Provide value for OAuth client secret");
        }
        if (this.gitHubApplicationDescription.useForSso && StringUtils.isEmpty((String)this.gitHubApplicationDescription.loginButtonDisplayName)) {
            return Optional.of("Provide value for login button display name");
        }
        return Optional.empty();
    }

    public Optional<String> validate(IStorageInfo storageInfo) throws StorageException {
        Optional<String> urlIssues;
        Optional<String> applicationValidationIssues = this.validateApplication();
        if (applicationValidationIssues.isPresent()) {
            return applicationValidationIssues;
        }
        Optional<String> allowedOrganizationsForSsoIssues = this.validateAllowedOrganizationsForSso();
        if (allowedOrganizationsForSsoIssues.isPresent()) {
            return allowedOrganizationsForSsoIssues;
        }
        if (!StringUtils.isEmpty((String)this.gitHubApplicationDescription.serverUrl)) {
            this.gitHubApplicationDescription.serverUrl = StringUtils.ensureEndsWith((String)this.gitHubApplicationDescription.serverUrl, (String)"/");
        }
        if ((urlIssues = this.validateUrl()).isPresent()) {
            return urlIssues;
        }
        Optional<String> connectivityIssues = this.validateConnectivity();
        if (connectivityIssues.isPresent()) {
            return connectivityIssues;
        }
        UserGroupIndex groupIndex = (UserGroupIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(UserGroupIndex.class);
        return this.validateGroupsExist(groupIndex);
    }

    private Optional<String> validateAllowedOrganizationsForSso() {
        if (this.isConfiguredInsecurely()) {
            return Optional.of(INSECURE_CONFIGURATION_MESSAGE);
        }
        if (this.gitHubApplicationDescription.useForSso && StringUtils.isEmpty((String)this.gitHubApplicationDescription.allowedOrganizations)) {
            return Optional.of("SSO via GitHub is configured but no allowed organizations are set, so logins will not be possible. Please provide a value for \"Allowed Organizations for SSO\".");
        }
        return Optional.empty();
    }

    private Optional<String> validateGroupsExist(UserGroupIndex groupIndex) throws StorageException {
        for (String groupName : this.gitHubApplicationDescription.getGroups()) {
            UserGroup group = groupIndex.getUserGroup(groupName);
            if (group != null) continue;
            return Optional.of("Group " + groupName + " does not exist!");
        }
        return Optional.empty();
    }

    @VisibleForTesting
    Optional<String> validateConnectivity() {
        try {
            App app = this.fetchGitHubApp();
            if (this.gitHubApplicationDescription.getAppId() != app.getId()) {
                return Optional.of("App ID returned (" + app.getId() + ") differs from configured App ID!");
            }
        }
        catch (ServiceCallException e) {
            return Optional.of("Failed to contact GitHub API: " + e.getMessage());
        }
        return Optional.empty();
    }

    @VisibleForTesting
    Optional<String> validateUrl() {
        if (StringUtils.isEmpty((String)this.gitHubApplicationDescription.serverUrl)) {
            return Optional.of("Server URL not provided!");
        }
        try {
            URI uri = new URI(this.gitHubApplicationDescription.serverUrl);
            if (!PROTOCOL_TO_PORT.containsKey(uri.getScheme())) {
                return Optional.of("Unsupported or missing protocol: " + uri.getScheme());
            }
            if (!StringUtils.stripSuffix((String)uri.getPath(), (String)"/").isEmpty()) {
                return Optional.of("Path of server URL must be empty!");
            }
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return Optional.of("Invalid server URL: " + e.getMessage());
        }
        return Optional.empty();
    }

    @VisibleForTesting
    boolean isConfiguredInsecurely() {
        return this.gitHubApplicationDescription.useForSso && this.gitHubApplicationDescription.getAllowedOrganizations().isEmpty() && !this.gitHubApplicationDescription.getGroups().isEmpty();
    }

    private App fetchGitHubApp() throws ServiceCallException {
        AccessTokenIndex accessTokenIndex = new AccessTokenIndex((IStore)new InMemoryStore());
        return new GitHubAppClient(this.gitHubApplicationDescription, accessTokenIndex, LogManager.getLogger()).getApp();
    }
}

