/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.index;

import com.teamscale.core.authenticate.github.index.LongKey;
import com.teamscale.core.authenticate.github.index.OrgOrUserInstallationsKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="github-installations", options={EStorageOption.BACKUP}, valueClasses={String.class})
public class GitHubInstallationIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "github-installations";
    @VisibleForTesting
    static final String ORGANISATION_TO_INSTALLATIONS_PREFIX = "o2i:";
    @VisibleForTesting
    static final String INSTALLATION_TO_APP_PREFIX = "i2a:";
    @VisibleForTesting
    static final String INSTALLATION_TO_REPOSITORIES_PREFIX = "i2r:";
    @VisibleForTesting
    static final String APP_TO_INSTALLATIONS_PREFIX = "a2i:";
    private static final ISerializer<TreeSet<Long>, byte[]> SERIALIZER = new ISerializer<TreeSet<Long>, byte[]>(){

        public byte @NonNull [] serialize(@NonNull TreeSet<Long> values) {
            byte[] result = new byte[values.size() * 8];
            int offset = 0;
            for (Long value : values) {
                ByteArrayUtils.putLongIntoByteArray((byte[])result, (int)offset, (long)value);
                offset += 8;
            }
            return result;
        }

        public @NonNull TreeSet<Long> deserialize(byte @NonNull [] bytes) {
            ArrayList<Long> result = new ArrayList<Long>();
            for (int i = 0; i < bytes.length; i += 8) {
                result.add(ByteArrayUtils.getLongFromByteArray((byte[])bytes, (int)i));
            }
            return new TreeSet<Long>(result);
        }
    };
    private static final String LOCK_SUFFIX = "UPDATE";
    private final ValueIndex<TreeSet<Long>> organizationToInstallationsIndex;
    private final ValueIndex<Long> installationToAppIndex;
    private final ValueIndex<TreeSet<String>> installationToRepositoriesIndex;
    private final ValueIndex<TreeSet<Long>> appToInstallationsIndex;

    public GitHubInstallationIndex(IStore store) {
        this.organizationToInstallationsIndex = GitHubInstallationIndex.createOrganizationToInstallationsIndex(store);
        this.installationToAppIndex = ValueIndex.forLong((IStore)new DelegatingPartitionStore(store, StringUtils.stringToBytes((String)INSTALLATION_TO_APP_PREFIX), INSTALLATION_TO_APP_PREFIX));
        this.installationToRepositoriesIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, StringUtils.stringToBytes((String)INSTALLATION_TO_REPOSITORIES_PREFIX), INSTALLATION_TO_REPOSITORIES_PREFIX));
        this.appToInstallationsIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, StringUtils.stringToBytes((String)APP_TO_INSTALLATIONS_PREFIX), APP_TO_INSTALLATIONS_PREFIX));
    }

    public Set<Long> getInstallationsForOrganization(OrgOrUserInstallationsKey key) throws StorageException {
        TreeSet value = (TreeSet)this.organizationToInstallationsIndex.getValue(key.asIndexKey());
        if (value == null) {
            return new TreeSet<Long>();
        }
        return value;
    }

    public List<Long> getAppIdsForOrganization(OrgOrUserInstallationsKey key) throws StorageException {
        return this.getAppAndInstallationIdsForOrganization(key).extractFirstList();
    }

    private PairList<Long, Long> getAppAndInstallationIdsForOrganization(OrgOrUserInstallationsKey key) throws StorageException {
        PairList result = new PairList();
        for (Long installationId : this.getInstallationsForOrganization(key)) {
            Optional<Long> appId = this.getAppId(new LongKey(installationId));
            appId.ifPresent(a -> result.add(a, (Object)installationId));
        }
        return result;
    }

    public Optional<String> getOrganizationByInstallation(Long installationId) throws StorageException {
        for (Pair entry : this.organizationToInstallationsIndex.getAllEntries()) {
            if (entry.getSecond() == null || !((TreeSet)entry.getSecond()).contains(installationId)) continue;
            OrgOrUserInstallationsKey orgOrUserInstallationsKey = OrgOrUserInstallationsKey.fromIndexKey((String)entry.getFirst());
            return Optional.of(orgOrUserInstallationsKey.organizationOrUser());
        }
        return Optional.empty();
    }

    public Optional<Long> getAppId(LongKey appKey) throws StorageException {
        return Optional.ofNullable((Long)this.installationToAppIndex.getValue(appKey.asIndexKey()));
    }

    public Set<Long> getInstallationIdsForAppId(Long appId) throws StorageException {
        String key = new LongKey(appId).asIndexKey();
        TreeSet result = (TreeSet)this.appToInstallationsIndex.getValue(key);
        if (result == null) {
            return new TreeSet<Long>();
        }
        return result;
    }

    public Set<String> getRepositoriesForInstallation(long installationId) throws StorageException {
        String key = new LongKey(installationId).asIndexKey();
        TreeSet result = (TreeSet)this.installationToRepositoriesIndex.getValue(key);
        if (result == null) {
            return new TreeSet<String>();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstallation(OrgOrUserInstallationsKey orgOrUserInstallationsKey, LongKey installationKey, long appId, List<String> availableRepositories) throws StorageException {
        Class<GitHubInstallationIndex> clazz = GitHubInstallationIndex.class;
        synchronized (GitHubInstallationIndex.class) {
            String key = orgOrUserInstallationsKey.asIndexKey();
            TreeSet<Long> installationIds = (TreeSet<Long>)this.organizationToInstallationsIndex.getValue(key);
            if (installationIds == null) {
                installationIds = new TreeSet<Long>();
            }
            installationIds.add(installationKey.key());
            this.organizationToInstallationsIndex.setValue(key, installationIds);
            this.installationToAppIndex.setValue(installationKey.asIndexKey(), (Object)appId);
            this.installationToRepositoriesIndex.setValue(installationKey.asIndexKey(), new TreeSet<String>(availableRepositories));
            LongKey appKey = new LongKey(appId);
            TreeSet<Long> values = (TreeSet<Long>)this.appToInstallationsIndex.getValue(appKey.asIndexKey());
            if (values == null) {
                values = new TreeSet<Long>();
            }
            values.add(installationKey.key());
            this.appToInstallationsIndex.setValue(appKey.asIndexKey(), values);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    public void addRepositoriesToInstallation(long installationId, List<String> availableRepositories) throws StorageException {
        if (availableRepositories.isEmpty()) {
            return;
        }
        String installationKey = new LongKey(installationId).asIndexKey();
        this.installationToRepositoriesIndex.runLocked(LOCK_SUFFIX, () -> {
            TreeSet values = (TreeSet)this.installationToRepositoriesIndex.getValue(installationKey);
            if (values == null) {
                values = new TreeSet();
            }
            values.addAll(availableRepositories);
            this.installationToRepositoriesIndex.setValue(installationKey, values);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApp(@NonNull String appId) throws StorageException {
        Class<GitHubInstallationIndex> clazz = GitHubInstallationIndex.class;
        synchronized (GitHubInstallationIndex.class) {
            TreeSet installationIds = (TreeSet)this.appToInstallationsIndex.getValue(appId);
            if (installationIds == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            for (Long installationId : installationIds) {
                String installationIdAsKey = new LongKey(installationId).asIndexKey();
                this.installationToRepositoriesIndex.removeValue(installationIdAsKey);
                this.installationToAppIndex.removeValue(installationIdAsKey);
                this.removeInstallationFromOrganizations(installationId);
            }
            this.appToInstallationsIndex.removeValue(appId);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void removeInstallationFromOrganizations(Long installationId) throws StorageException {
        for (Pair organizationEntry : this.organizationToInstallationsIndex.getAllEntries()) {
            if (!((TreeSet)organizationEntry.getSecond()).remove(installationId)) continue;
            if (((TreeSet)organizationEntry.getSecond()).isEmpty()) {
                this.organizationToInstallationsIndex.removeValue((String)organizationEntry.getFirst());
                continue;
            }
            this.organizationToInstallationsIndex.setValue((String)organizationEntry.getFirst(), (Object)((TreeSet)organizationEntry.getSecond()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstallation(OrgOrUserInstallationsKey orgOrUserInstallationsKey, long installationId) throws StorageException {
        Class<GitHubInstallationIndex> clazz = GitHubInstallationIndex.class;
        synchronized (GitHubInstallationIndex.class) {
            String installationIndexKey = orgOrUserInstallationsKey.asIndexKey();
            this.removeInstallations(this.organizationToInstallationsIndex, installationId, installationIndexKey);
            String installationKey = new LongKey(installationId).asIndexKey();
            this.installationToRepositoriesIndex.removeValue(installationKey);
            Long appId = (Long)this.installationToAppIndex.getValue(installationKey);
            if (appId == null) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            this.installationToAppIndex.removeValue(installationKey);
            String appKey = new LongKey(appId).asIndexKey();
            this.removeInstallations(this.appToInstallationsIndex, installationId, appKey);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private void removeInstallations(ValueIndex<TreeSet<Long>> delegateIndex, long installationIdToRemove, String indexKey) throws StorageException {
        TreeSet values = (TreeSet)delegateIndex.getValue(indexKey);
        if (values == null) {
            return;
        }
        values.remove(installationIdToRemove);
        if (values.isEmpty()) {
            delegateIndex.removeValue(indexKey);
        } else {
            delegateIndex.setValue(indexKey, (Object)values);
        }
    }

    public void removeRepositoriesFromInstallation(long installationId, List<String> removedRepositories) throws StorageException {
        if (removedRepositories.isEmpty()) {
            return;
        }
        this.installationToRepositoriesIndex.runLocked(LOCK_SUFFIX, () -> this.doRemoveRepositoriesFromInstallation(installationId, removedRepositories));
    }

    private void doRemoveRepositoriesFromInstallation(long installationId, List<String> removedRepositories) throws StorageException {
        String installationKey = new LongKey(installationId).asIndexKey();
        TreeSet values = (TreeSet)this.installationToRepositoriesIndex.getValue(installationKey);
        if (values == null) {
            return;
        }
        removedRepositories.forEach(values::remove);
        if (values.isEmpty()) {
            this.installationToRepositoriesIndex.removeValue(installationKey);
        } else {
            this.installationToRepositoriesIndex.setValue(installationKey, (Object)values);
        }
    }

    public List<String> listInstalledOrganizationsOrUsers() throws StorageException {
        return this.organizationToInstallationsIndex.getAllEntries().getFirstList();
    }

    public PairList<String, TreeSet<Long>> getAllOrganisationInstallations() throws StorageException {
        return this.organizationToInstallationsIndex.getAllEntries();
    }

    public PairList<String, Long> getAllAppInstallations() throws StorageException {
        return this.installationToAppIndex.getAllEntries();
    }

    public PairList<String, TreeSet<String>> getAllRepositoryInstallations() throws StorageException {
        return this.installationToRepositoriesIndex.getAllEntries();
    }

    public PairList<String, TreeSet<Long>> getAllInstalledApps() throws StorageException {
        return this.appToInstallationsIndex.getAllEntries();
    }

    public Set<Long> getAllInstallationsForApp(String appId) throws StorageException {
        Set value = (Set)this.appToInstallationsIndex.getValue(appId);
        if (value == null) {
            return new TreeSet<Long>();
        }
        return value;
    }

    public @Nullable String getOrganisationForInstallation(long installationId) throws StorageException {
        List organisations = this.getAllOrganisationInstallations().filter((org, installations) -> installations.contains(installationId)).extractFirstList();
        if (organisations.isEmpty()) {
            return null;
        }
        CCSMAssert.isTrue((organisations.size() == 1 ? 1 : 0) != 0, () -> String.format("Expected the installation id '%s' to be mapped to a single user or organisation.", installationId));
        return OrgOrUserInstallationsKey.fromIndexKey((String)organisations.get(0)).organizationOrUser();
    }

    private static ValueIndex<TreeSet<Long>> createOrganizationToInstallationsIndex(IStore store) {
        return ValueIndex.of((IStore)new DelegatingPartitionStore(store, StringUtils.stringToBytes((String)ORGANISATION_TO_INSTALLATIONS_PREFIX), ORGANISATION_TO_INSTALLATIONS_PREFIX), SERIALIZER);
    }
}

