/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.ldap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.authenticate.ldap.LDAPSynchronizeTriggerAuto;
import com.teamscale.core.authenticate.ldap.LDAPUtils;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import com.teamscale.core.option.ScheduleOption;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultEntry;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="auth.ldap.server", name="LDAP Server", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AUTH, orderingHint=100)
@IndexValueClass(containedInBackup=true)
public class LDAPServerDescription
extends ServerDescriptionBase {
    public static final String OPTION_ID = "auth.ldap.server";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="hostname")
    @OptionFieldDescription(name="The hostname of the LDAP server")
    public String hostname = "";
    @JsonProperty(value="port")
    @OptionFieldDescription(name="The port to be used. Default ports are 389 for LDAP and 636 for LDAPS")
    public int port = 389;
    @JsonProperty(value="useSSL")
    @OptionFieldDescription(name="Whether to use SSL when connecting to the LDAP server")
    public boolean useSSL = false;
    @JsonProperty(value="baseDN")
    @OptionFieldDescription(name="The base DN used for searching users")
    public String baseDN = "";
    @JsonProperty(value="groupsBaseDN")
    @OptionFieldDescription(name="The base DN used for searching groups")
    public String groupsBaseDN = "";
    @JsonProperty(value="groupAttribute")
    @OptionFieldDescription(name="The LDAP attribute used for groups")
    public String groupAttribute = "cn";
    @JsonProperty(value="bindDN")
    @OptionFieldDescription(name="The DN used for the initial bind (optional)")
    public String bindDN = "";
    @JsonProperty(value="bindPassword")
    @PasswordOption
    @OptionFieldDescription(name="The password used for the initial bind (optional)")
    public String bindPassword = "";
    @JsonProperty(value="loginAttribute")
    @OptionFieldDescription(name="The LDAP attribute for the login")
    public String loginAttribute = "sAMAccountName";
    @JsonProperty(value="memberUid")
    @OptionFieldDescription(name="The LDAP attribute used to store group members")
    public String memberUid = "member";
    @JsonProperty(value="firstNameAttribute")
    @OptionFieldDescription(name="The LDAP attribute for the first name")
    public String firstNameAttribute = "givenName";
    @JsonProperty(value="lastNameAttribute")
    @OptionFieldDescription(name="The LDAP attribute for the last name")
    public String lastNameAttribute = "sn";
    @JsonProperty(value="emailAttribute")
    @OptionFieldDescription(name="The LDAP attribute for the email")
    public String emailAttribute = "mail";
    @JsonProperty(value="updateSchedule")
    @OptionFieldDescription(name="Automatic server synchronization schedule")
    @ScheduleOption(triggerClass=LDAPSynchronizeTriggerAuto.class)
    public String updateSchedule = "";
    @JsonProperty(value="loginEnabled")
    @OptionFieldDescription(name="Allow Login with LDAP", description="If disabled, login via LDAP will no longer be possible. Permission management via LDAP will continue to work.")
    public boolean loginEnabled = true;

    @Override
    public EAuthenticationTool getAuthenticationTool() {
        return EAuthenticationTool.LDAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        String superError = super.validate(storageInfo, instanceConfiguration);
        if (superError != null) {
            return superError;
        }
        if (StringUtils.isEmpty((String)this.loginAttribute)) {
            return "Login attribute missing!";
        }
        if (StringUtils.isEmpty((String)this.groupAttribute)) {
            return "Group attribute missing!";
        }
        try {
            LDAPUtils.removeConnectionPool(this);
            LDAPConnectionPool pool = LDAPUtils.getConnectionPool(this);
            SearchResultEntry userBaseDnEntry = pool.getEntry(this.baseDN);
            if (userBaseDnEntry == null) {
                String string = "User Base DN " + this.baseDN + " was not found.";
                return string;
            }
            SearchResultEntry groupBaseDnEntry = pool.getEntry(this.groupsBaseDN);
            if (groupBaseDnEntry == null) {
                String string = "Group Base DN " + this.groupsBaseDN + " was not found.";
                return string;
            }
            String string = null;
            return string;
        }
        catch (LDAPException e) {
            String string = "Could not connect to the server: " + e.getMessage();
            return string;
        }
        finally {
            LDAPUtils.removeConnectionPool(this);
        }
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.hostname);
    }

    public String getUrl() {
        if (this.useSSL) {
            return "ldaps://" + this.hostname + ":" + this.port;
        }
        return "ldap://" + this.hostname + ":" + this.port;
    }

    public String toString() {
        return this.getUrl();
    }

    public String getConnectionPoolKey() {
        StringBuilder poolIdBuilder = new StringBuilder();
        poolIdBuilder.append(this.hostname).append(this.port).append(this.useSSL).append(this.baseDN).append(this.groupsBaseDN).append(this.groupAttribute).append(this.bindDN).append(this.loginAttribute).append(this.memberUid).append(this.firstNameAttribute).append(this.lastNameAttribute).append(this.emailAttribute).append(this.updateSchedule).append(this.userServer).append(this.loginEnabled);
        return poolIdBuilder.toString();
    }
}

