/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.ldap;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.SynchronizeGroupsAsyncStrategyBase;
import com.teamscale.core.authenticate.ldap.LDAPServerDescription;
import com.teamscale.core.authenticate.ldap.LDAPSynchronizeTriggerManual;
import com.teamscale.core.authenticate.ldap.LDAPUtils;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.runtime.impl.progress.GlobalAnalysisProgressIndex;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

class LDAPSynchronizeGroupsAsyncStrategy
extends SynchronizeGroupsAsyncStrategyBase<LDAPServerDescription> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PERMISSION_BASE_GROUP_PROPERTY_NAME = "com.teamscale.enable-ldap-group-auto-import.permission-base";
    private static final String PERMISSIONS_BASE_GROUP = System.getProperty("com.teamscale.enable-ldap-group-auto-import.permission-base");
    private final PermissionIndex permissionIndex;
    private final ServerOptionIndex optionIndex;

    public LDAPSynchronizeGroupsAsyncStrategy(NamedServer<LDAPServerDescription> server, UserIndex userIndex, UserGroupIndex groupIndex, GlobalAnalysisProgressIndex progressIndex, PermissionIndex permissionIndex, ServerOptionIndex optionIndex, IImportGroupsStrategy importGroupsStrategy, IMessageBroker messageBroker) {
        super(server, userIndex, groupIndex, progressIndex, importGroupsStrategy, messageBroker);
        this.permissionIndex = permissionIndex;
        this.optionIndex = optionIndex;
    }

    @Override
    protected Set<UserGroup> retrieveNewGroups() throws StorageException {
        if (!EFeatureToggle.ENABLE_LDAP_GROUP_AUTO_IMPORT.isEnabled()) {
            return Collections.emptySet();
        }
        List<UserGroup> retrievedGroups = LDAPUtils.searchForAllGroupEntries(this.getServer().name(), (LDAPServerDescription)this.getServer().serverDescription());
        Set<UserGroup> groupsToImport = LDAPSynchronizeGroupsAsyncStrategy.filterNewGroups(this.groupIndex, retrievedGroups);
        LOGGER.info("Retrieved new groups: " + String.valueOf(groupsToImport));
        return groupsToImport;
    }

    private static Set<UserGroup> filterNewGroups(UserGroupIndex groupIndex, List<UserGroup> retrievedGroups) throws StorageException {
        List<UserGroup> existingGroups = groupIndex.getUserGroups(CollectionUtils.map(retrievedGroups, UserGroup::getName));
        HashSet<UserGroup> groupsToImport = new HashSet<UserGroup>();
        for (int i = 0; i < retrievedGroups.size(); ++i) {
            if (existingGroups.get(i) != null) continue;
            groupsToImport.add(retrievedGroups.get(i));
        }
        return groupsToImport;
    }

    @Override
    protected void copyPermissionsOfNewGroup(UserGroup newGroup) throws StorageException {
        if (!EFeatureToggle.ENABLE_LDAP_GROUP_AUTO_IMPORT.isEnabled() || StringUtils.isEmpty((String)PERMISSIONS_BASE_GROUP)) {
            return;
        }
        PermissionUtils.copyPermissions(this.groupIndex, this.permissionIndex, PERMISSIONS_BASE_GROUP, newGroup.getName());
    }

    @Override
    protected boolean groupExists(UserGroup group) throws StorageException, AuthenticationToolException {
        try {
            return LDAPUtils.groupExists(group.getRemoteGroup(), (LDAPServerDescription)this.getServer().serverDescription(), this.optionIndex);
        }
        catch (LDAPException e) {
            throw new AuthenticationToolException("Failed to check for group existence.", e);
        }
    }

    @Override
    protected Class<? extends PrivilegedTriggerBase> getTriggerClass() {
        return LDAPSynchronizeTriggerManual.class;
    }
}

