/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.saml;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IAutoCompletionStrategy;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.IImportUsersStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SamlAuthenticationProvider
implements IAuthenticationToolProvider {
    private final GlobalStorageSystem globalStorageSystem;

    public SamlAuthenticationProvider(GlobalStorageSystem globalStorageSystem) {
        this.globalStorageSystem = globalStorageSystem;
    }

    @Override
    public EAuthenticationTool getAuthenticationTool() {
        return EAuthenticationTool.SAML;
    }

    @Override
    public IImportUsersStrategy createImportUsersStrategy(String serverName) throws StorageException {
        UserIndex userIndex = (UserIndex)this.globalStorageSystem.openGlobalIndex(UserIndex.class);
        return userName -> SamlAuthenticationProvider.getUsers(userName, userIndex);
    }

    private static List<User> getUsers(String userName, UserIndex userIndex) throws StorageException {
        ArrayList<User> result = new ArrayList<User>();
        User user = userIndex.getUser(userName);
        if (user == null && userName.contains("@")) {
            List<User> usersForMail = userIndex.getUsersForMail(userName);
            result.addAll(CollectionUtils.filterNullEntries((Collection)CollectionUtils.emptyIfNull(usersForMail)));
        }
        if (user != null) {
            result.add(user);
        }
        return result.stream().filter(u -> StringUtils.emptyIfNull((String)u.getAuthenticator()).startsWith("SAML only")).toList();
    }

    @Override
    public IImportGroupsStrategy createImportGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return (IImportGroupsStrategy)SamlAuthenticationProvider.notSupported();
    }

    @Override
    public ISynchronizeUsersStrategy createSynchronizeUsersStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return (ISynchronizeUsersStrategy)SamlAuthenticationProvider.notSupported();
    }

    @Override
    public ISynchronizeGroupsStrategy createSynchronizeGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return (ISynchronizeGroupsStrategy)SamlAuthenticationProvider.notSupported();
    }

    @Override
    public ISynchronizeUserGroupsStrategy createSynchronizeUserGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return (ISynchronizeUserGroupsStrategy)SamlAuthenticationProvider.notSupported();
    }

    @Override
    public IAutoCompletionStrategy createUserAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return IAutoCompletionStrategy.empty();
    }

    @Override
    public IAutoCompletionStrategy createGroupAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return IAutoCompletionStrategy.empty();
    }

    @Override
    public List<String> getServerList() throws StorageException {
        return AuthenticationToolUtils.getServerNames(this.getAuthenticationTool(), (ServerOptionIndex)this.globalStorageSystem.openGlobalIndex(ServerOptionIndex.class));
    }

    private static <T> T notSupported() throws AuthenticationToolException {
        throw new AuthenticationToolException("Not supported");
    }
}

