/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings.metrics;

import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.findings.metrics.FindingsMetricBase;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class FindingsCountMetric
extends FindingsMetricBase {
    public static final String BASE_NAME = "Number of Findings";
    private static final String BASE_DESCRIPTION = "The number of %sfindings";
    public static final FindingsCountMetric FINDINGS_COUNT = new FindingsCountMetric(ETrafficLightColor.UNKNOWN);
    public static final FindingsCountMetric FINDINGS_COUNT_RED = new FindingsCountMetric(ETrafficLightColor.RED);
    public static final FindingsCountMetric FINDINGS_COUNT_YELLOW = new FindingsCountMetric(ETrafficLightColor.YELLOW);

    private FindingsCountMetric(ETrafficLightColor color) {
        super(FindingsCountMetric.generateIdFromName(BASE_NAME, FindingsCountMetric.getColorString(color)), BASE_NAME + FindingsCountMetric.getColorString(color, " (", ")", true), String.format(BASE_DESCRIPTION, FindingsCountMetric.getColorString(color, "", " ")), color);
    }

    protected FindingsCountMetric(String id, String name, String description, ETrafficLightColor color) {
        super(id, name, description, color);
    }

    @Override
    public void registerInSchema(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric(this.getId(), schema.createMetricIndexSource(this.getId()), this.getName(), this.getDescription(), EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, EMetricProperty.ARCHITECTURE_RELEVANT);
    }
}

