/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.schema;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public interface IMetricSchemaRetriever {
    public MetricDirectorySchema getFullMetricSchema(HistoryAccessOption var1) throws StorageException;

    default public MetricDirectorySchema getFullMetricSchema() throws StorageException {
        return this.getFullMetricSchema(HistoryAccessOption.readHeadUnbranched());
    }

    default public MetricDirectorySchema getHiddenMetricSchema(HistoryAccessOption historyAccess) throws StorageException {
        return this.getFullMetricSchema(historyAccess).extractHiddenSchema();
    }

    default public MetricDirectorySchema getHiddenMetricSchema() throws StorageException {
        return this.getHiddenMetricSchema(HistoryAccessOption.readHeadUnbranched());
    }

    default public MetricDirectorySchema getPublicMetricSchema(HistoryAccessOption historyAccess) throws StorageException {
        return this.getFullMetricSchema(historyAccess).extractPublicSchema();
    }

    default public MetricDirectorySchema getPublicMetricSchema() throws StorageException {
        return this.getPublicMetricSchema(HistoryAccessOption.readHeadUnbranched());
    }

    public static final class EmptySchemaRetriever
    implements IMetricSchemaRetriever {
        @Override
        public MetricDirectorySchema getFullMetricSchema(HistoryAccessOption historyAccess) {
            return MetricDirectorySchema.EMPTY;
        }
    }

    public static class IndexBasedMetricSchemaRetriever
    implements IMetricSchemaRetriever {
        private final String indexName;
        private final ProjectStorageSystem projectStorageSystem;
        private final ConcurrentMap<HistoryAccessOption, MetricDirectorySchema> fullSchemas = new ConcurrentHashMap<HistoryAccessOption, MetricDirectorySchema>();

        public IndexBasedMetricSchemaRetriever(String indexName, ProjectStorageSystem projectStorageSystem) {
            CCSMAssert.isNotNull((Object)indexName);
            CCSMAssert.isNotNull((Object)projectStorageSystem);
            this.indexName = indexName;
            this.projectStorageSystem = projectStorageSystem;
        }

        @Override
        public MetricDirectorySchema getFullMetricSchema(HistoryAccessOption historyAccess) throws StorageException {
            MetricDirectorySchema result = (MetricDirectorySchema)CollectionUtils.computeIfAbsentWithException(this.fullSchemas, (Object)historyAccess, options -> ((MetricSchemaIndex)this.projectStorageSystem.openProjectIndex(MetricSchemaIndex.class, this.indexName, options)).getFullSchema());
            CCSMAssert.isNotNull((Object)result, (String)"Assuming that the schema returned for an index is never null.");
            return result;
        }
    }
}

