/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.source;

import com.google.common.collect.Iterables;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.source.DerivedMetricSourceBase;
import com.teamscale.core.metrics.source.MetricAggregationUtils;
import com.teamscale.core.metrics.values.EMetricValueType;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public abstract class DoubleCalculatorMetricSourceBase
extends DerivedMetricSourceBase {
    private static final long serialVersionUID = 1L;
    private final int arg1MetricOffset;
    private final int arg2MetricOffset;

    protected DoubleCalculatorMetricSourceBase(int arg1MetricOffset, int arg2MetricOffset) {
        this.arg1MetricOffset = arg1MetricOffset;
        this.arg2MetricOffset = arg2MetricOffset;
    }

    @Override
    public void init(int ownOffset, MetricDirectorySchema schema) throws ConQATException {
        super.init(ownOffset, schema);
        DoubleCalculatorMetricSourceBase.expectMetricType(ownOffset, schema, EMetricValueType.NUMERIC);
        DoubleCalculatorMetricSourceBase.expectMetricType(this.arg1MetricOffset, schema, EMetricValueType.NUMERIC);
        DoubleCalculatorMetricSourceBase.expectMetricType(this.arg2MetricOffset, schema, EMetricValueType.NUMERIC);
    }

    @Override
    public Object aggregate(List<Object> values, MetricDirectorySchemaEntry schemaEntry) {
        if (schemaEntry.getAggregation() == MetricDirectorySchemaEntry.EAggregation.NONE) {
            return null;
        }
        return MetricAggregationUtils.aggregateDouble(values, schemaEntry.getAggregation());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void generateValue(Object[] values, boolean hasChildren, MetricDirectorySchemaEntry schemaEntry, CounterSet<String> codeScopeNames) {
        if (hasChildren && schemaEntry.getAggregation() != MetricDirectorySchemaEntry.EAggregation.NONE) {
            return;
        }
        CodeScopeName codeScopeName = null;
        if (codeScopeNames.getKeys().size() == 1) {
            codeScopeName = new CodeScopeName((String)Iterables.getOnlyElement((Iterable)codeScopeNames.getKeys()));
        }
        Object arg1 = values[this.arg1MetricOffset];
        Object arg2 = values[this.arg2MetricOffset];
        if (arg1 instanceof Number) {
            Number number1 = (Number)arg1;
            if (arg2 instanceof Number) {
                Number number2 = (Number)arg2;
                values[this.offset] = this.calculateValue(number1.doubleValue(), number2.doubleValue(), codeScopeName);
                return;
            }
        }
        values[this.offset] = null;
    }

    protected abstract @Nullable Double calculateValue(double var1, double var3, @Nullable CodeScopeName var5);
}

