/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.store;

import com.teamscale.core.migration.store.IBatchStorageMigrator;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.factory.IFactory;

class BatchMigratingStore
extends DelegatingStore {
    private final IBatchStorageMigrator migrator;
    private final IStore temporaryTargetStore;
    private final IStore targetStore;
    private final IndexSchema targetSchema;
    private final String targetStoreName;
    private final IFactory<IStore, StorageException> tempStoreFactory;

    public BatchMigratingStore(IFactory<IStore, StorageException> tempStoreFactory, IStore targetStore, String targetStoreName, IndexSchema targetSchema, IBatchStorageMigrator migrator) throws StorageException {
        super((IStore)tempStoreFactory.create());
        this.temporaryTargetStore = (IStore)tempStoreFactory.create();
        this.tempStoreFactory = tempStoreFactory;
        this.targetStore = targetStore;
        this.migrator = migrator;
        this.targetSchema = targetSchema;
        this.targetStoreName = targetStoreName;
    }

    public void batchMigrate() throws StorageException {
        this.migrator.migrate((IStore)this, this.temporaryTargetStore, this.tempStoreFactory);
        StorageUtils.copyStore((IStore)this.temporaryTargetStore, (IStore)this.targetStore);
        if (this.isBranchedStore()) {
            IStore branchStore = this.applyStoreOptions();
            new CommitLayeringBranchingLayer(branchStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout()).recalculateHeadCommitPointers();
        }
    }

    private IStore applyStoreOptions() throws StorageException {
        return IndexSchema.applyStoreOptions((SchemaEntry)this.targetSchema.getEntry(this.targetStoreName), (IStore)this.targetStore, (boolean)true, null, null, null);
    }

    private boolean isBranchedStore() throws StorageException {
        SchemaEntry schemaEntry = this.targetSchema.getEntry(this.targetStoreName);
        if (schemaEntry == null) {
            throw new StorageException("No schema entry found for store " + this.targetStoreName);
        }
        return schemaEntry.usesOption(EStorageOption.BRANCHED);
    }
}

