/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.PermissionLookup;
import com.teamscale.core.permissions.PermissionModifier;
import com.teamscale.core.permissions.PermissionSummary;
import com.teamscale.core.permissions.UserPermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EConfigurationFeature;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import jakarta.ws.rs.ForbiddenException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class ServicePermissions {
    private final IProjectId projectId;
    private final UserPermissions userPermissions;
    private final ProjectIndex projectIndex;
    private final PermissionIndex permissionIndex;

    public ServicePermissions(UserPermissions userPermissions, IProjectId projectId, ProjectIndex projectIndex, PermissionIndex permissionIndex) {
        this.projectId = projectId;
        this.projectIndex = projectIndex;
        this.permissionIndex = permissionIndex;
        this.userPermissions = userPermissions;
    }

    public PermissionSummary createPermissionSummary() {
        return this.userPermissions.createPermissionSummary();
    }

    public PermissionLookup<EBasicPermission> getPermissionLookup(EBasicPermissionScope permissionScope) {
        return this.userPermissions.getBasicPermissions().getBasicPermissionLookup(permissionScope);
    }

    public PermissionLookup<EProjectPermission> getProjectPermissionLookup() {
        return this.userPermissions.getProjectPermissions().getProjectPermissionLookup();
    }

    public void checkProjectPermission(IProjectId projectId, EProjectPermission projectPermission) throws StorageException, ForbiddenException {
        this.userPermissions.getProjectPermissions().checkProjectPermission(this.projectIndex, projectId, projectPermission);
    }

    public boolean checkForExistingProject(IProjectId projectId) throws StorageException {
        return this.projectIndex.tryResolveProject(projectId).isPresent();
    }

    public void checkProjectPermission(EProjectPermission projectPermission) throws StorageException {
        this.userPermissions.getProjectPermissions().checkProjectPermission(this.projectIndex, this.projectId, projectPermission);
    }

    public boolean userHasProjectPermission(IProjectId projectId, EProjectPermission projectPermission) throws StorageException {
        return this.userPermissions.getProjectPermissions().hasProjectPermission(this.projectIndex, projectId, projectPermission);
    }

    public boolean userHasProjectPermission(EProjectPermission projectPermission) throws StorageException {
        return this.userHasProjectPermission(this.projectId, projectPermission);
    }

    public List<ProjectInfo> getVisibleProjects() throws StorageException {
        return this.getVisibleProjects(false, false);
    }

    public List<ProjectInfo> getVisibleProjects(boolean includeDeleting, boolean includeReanalyzing) throws StorageException {
        return this.userPermissions.getProjectPermissions().getVisibleProjects(this.projectIndex, includeDeleting, includeReanalyzing);
    }

    public void checkReadCurrentProject() throws StorageException {
        this.userPermissions.getProjectPermissions().checkProjectPermission(this.projectIndex, this.projectId, EProjectPermission.VIEW);
    }

    public void checkReadInProject(IProjectId projectId) throws StorageException {
        this.userPermissions.getProjectPermissions().checkProjectPermission(this.projectIndex, projectId, EProjectPermission.VIEW);
    }

    public boolean mayReadProject(IProjectId projectId) throws StorageException {
        return this.userPermissions.getProjectPermissions().hasProjectPermission(this.projectIndex, projectId, EProjectPermission.VIEW);
    }

    public void checkReadInProjects(Collection<? extends IProjectId> projectIds) throws StorageException {
        this.checkPermissionInProjects(projectIds, EProjectPermission.VIEW);
    }

    private void checkPermissionInProjects(Collection<? extends IProjectId> projectIds, EProjectPermission projectPermission) throws StorageException {
        ArrayList<IProjectId> projectsWithoutPermissions = new ArrayList<IProjectId>();
        for (IProjectId iProjectId : projectIds) {
            if (this.userHasProjectPermission(iProjectId, projectPermission)) continue;
            projectsWithoutPermissions.add(iProjectId);
        }
        if (!projectsWithoutPermissions.isEmpty()) {
            throw new ForbiddenException("You do not have the necessary permissions " + projectPermission.readableName + " for the following projects: " + StringUtils.concat(projectsWithoutPermissions, (String)", "));
        }
    }

    public boolean hasBasicPermission(EBasicPermissionScope permissionScope, String instanceId, EBasicPermission instancePermission) {
        return this.userPermissions.getBasicPermissions().hasBasicPermission(permissionScope, instanceId, instancePermission);
    }

    public void checkBasicPermission(EBasicPermissionScope permissionScope, String instanceId, EBasicPermission basicPermission) throws ForbiddenException {
        this.userPermissions.getBasicPermissions().checkBasicPermission(permissionScope, instanceId, basicPermission);
    }

    public void checkBasicPermissionForAll(EBasicPermissionScope permissionScope, Collection<String> instanceIds, EBasicPermission basicPermission) {
        this.userPermissions.getBasicPermissions().checkBasicPermissionForAll(permissionScope, instanceIds, basicPermission);
    }

    public boolean hasGlobalPermission(EGlobalPermission globalPermission) {
        return this.userPermissions.hasGlobalPermission(globalPermission);
    }

    public void checkAccessAdministrativeServices() {
        if (!this.userPermissions.hasGlobalPermission(EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES)) {
            throw new ForbiddenException("User must be admin to access this feature.");
        }
    }

    public boolean mayViewAuthenticationServers() {
        return this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_GROUPS) || this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_USERS);
    }

    public boolean mayConfigureProjects() {
        return this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_PROJECTS);
    }

    public boolean mayAccessProjectsPerspective() {
        return this.mayConfigureProjects() || this.mayConfigureAnalysisProfiles() || this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_METRIC_THRESHOLD_CONFIGURATIONS) || this.userPermissions.hasGlobalPermission(EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA) || this.userPermissions.hasGlobalPermission(EGlobalPermission.EDIT_EXTERNAL_METRICS_SCHEMA) || this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_PROFILERS);
    }

    public boolean mayAccessAdminPerspective() {
        return this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_USERS) || this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_GROUPS) || this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_EXTERNAL_CREDENTIALS) || this.userPermissions.hasGlobalPermission(EGlobalPermission.EDIT_GLOBAL_NOTIFICATION_SETTINGS) || this.userPermissions.hasGlobalPermission(EGlobalPermission.BACKUP);
    }

    public boolean mayAccessAuditPerspective() {
        return EFeatureToggle.AUDIT_FEATURES.isEnabled();
    }

    public boolean mayConfigureAnalysisProfiles() {
        return this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_ANALYSIS_PROFILES);
    }

    public boolean mayConfigureExternalCredentials() {
        return this.userPermissions.mayAccessConfigurationFeature(EConfigurationFeature.CONFIGURE_EXTERNAL_CREDENTIALS);
    }

    public boolean mayViewSystemStatus() {
        return this.hasGlobalPermission(EGlobalPermission.VIEW_SYSTEM_STATUS);
    }

    public boolean mayRetrieveGlobalAnalysisProgress() {
        return this.mayViewSystemStatus() || this.hasGlobalPermission(EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES);
    }

    public void checkBackupAccess() throws ForbiddenException {
        this.userPermissions.checkGlobalPermission(EGlobalPermission.BACKUP);
    }

    public void checkBackupPermissions(boolean includeGlobalData, Set<? extends IProjectId> includedProjects) throws ForbiddenException, StorageException {
        if (includeGlobalData) {
            this.checkGlobalPermission(EGlobalPermission.BACKUP);
        }
        for (IProjectId iProjectId : includedProjects) {
            this.checkProjectPermission(iProjectId, EProjectPermission.BACKUP_DATA);
        }
    }

    public void checkCommitHook(IProjectId projectId) throws StorageException {
        this.checkProjectPermission(projectId, EProjectPermission.TRIGGER_COMMIT_HOOK);
    }

    public void checkEditRedBlacklistFindings() throws StorageException {
        this.checkProjectPermission(EProjectPermission.EXCLUDE_RED_FINDINGS);
    }

    public void checkEditYellowBlacklistFindings() throws StorageException {
        this.checkProjectPermission(EProjectPermission.EXCLUDE_YELLOW_FINDINGS);
    }

    public PermissionModifier createPermissionModifier() {
        return new PermissionModifier(this.projectIndex, this.permissionIndex, this.userPermissions);
    }

    public void checkGlobalPermission(EGlobalPermission permission) throws ForbiddenException {
        this.userPermissions.checkGlobalPermission(permission);
    }

    public boolean hasAdminPerspectiveSubviewAccess() {
        return this.hasGlobalPermission(EGlobalPermission.BACKUP) || this.hasGlobalPermission(EGlobalPermission.EDIT_GLOBAL_NOTIFICATION_SETTINGS) || this.hasGlobalPermission(EGlobalPermission.CREATE_USERS) || this.hasGlobalPermission(EGlobalPermission.CREATE_GROUPS) || this.hasGlobalPermission(EGlobalPermission.EDIT_ROLES) || this.hasGlobalPermission(EGlobalPermission.EDIT_GLOBAL_ROLES) || this.hasGlobalPermission(EGlobalPermission.CREATE_EXTERNAL_TOOL_ACCOUNTS);
    }
}

