/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.permissions.BasicPermissions;
import com.teamscale.core.permissions.PermissionSummary;
import com.teamscale.core.permissions.ProjectPermissions;
import com.teamscale.core.permissions.roles.EConfigurationFeature;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.GlobalRole;
import com.teamscale.core.user.User;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.conqat.lib.commons.collections.CollectionUtils;

class UserPermissions {
    private final Set<EConfigurationFeature> configurationFeatures = new HashSet<EConfigurationFeature>();
    private final Set<EGlobalPermission> globalPermissions = new HashSet<EGlobalPermission>();
    private final ProjectPermissions projectPermissions;
    private final BasicPermissions basicPermissions;
    private final Supplier<User> authorizedUserSupplier = () -> {
        if (user == null) {
            throw new NotAuthorizedException((Object)"No user logged in.", new Object[0]);
        }
        return user;
    };

    public UserPermissions(User user) {
        this.basicPermissions = new BasicPermissions();
        this.projectPermissions = new ProjectPermissions();
    }

    public UserPermissions() {
        this(null);
    }

    public User getLoggedInUserChecked() {
        return this.authorizedUserSupplier.get();
    }

    public void addGlobalPermissions(GlobalRole globalRole) {
        this.globalPermissions.addAll(globalRole.getPermissions());
    }

    public void addConfigurationFeature(EConfigurationFeature configurationFeature) {
        this.configurationFeatures.add(configurationFeature);
    }

    public ProjectPermissions getProjectPermissions() {
        return this.projectPermissions;
    }

    public BasicPermissions getBasicPermissions() {
        return this.basicPermissions;
    }

    public void checkGlobalPermission(EGlobalPermission globalPermission) throws ForbiddenException {
        if (!this.hasGlobalPermission(globalPermission)) {
            String message = "The current user doesn't have the global permission '" + globalPermission.readableName + "'.";
            AuditLogs.failedGlobalPermissionCheck(globalPermission, message);
            throw new ForbiddenException(message);
        }
    }

    public boolean hasGlobalPermission(EGlobalPermission globalPermission) {
        return this.globalPermissions.contains(globalPermission);
    }

    public PermissionSummary createPermissionSummary() {
        return new PermissionSummary((Set<EConfigurationFeature>)CollectionUtils.asUnmodifiable(this.configurationFeatures), (Set<EGlobalPermission>)CollectionUtils.asUnmodifiable(this.globalPermissions), this.projectPermissions.getGlobalEProjectPermissions(), this.projectPermissions.getProjectPermissionsByProject());
    }

    public boolean mayAccessConfigurationFeature(EConfigurationFeature feature) {
        return this.configurationFeatures.contains((Object)feature);
    }
}

