/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccessBase;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;

public class AnalysisStepGlobalIndexAccess
extends AnalysisStepIndexAccessBase {
    private final GlobalIndexAccess indexAccess;

    AnalysisStepGlobalIndexAccess(Field field, List<Field> fieldStack, GlobalIndexAccess indexAccess) throws TriggerCompilationException {
        super(field, fieldStack, AnalysisStepGlobalIndexAccess.resolveIndexNameFromIndexClass(AnalysisStepGlobalIndexAccess.asGlobalIndexType(field.getType()), field));
        this.indexAccess = indexAccess;
    }

    private static Class<? extends IGlobalIndex> asGlobalIndexType(Class<?> fieldType) throws TriggerCompilationException {
        if (!IGlobalIndex.class.isAssignableFrom(fieldType)) {
            throw new TriggerCompilationException("May use global index access annotation only for global indexes, not for " + fieldType.getSimpleName());
        }
        return fieldType.asSubclass(IGlobalIndex.class);
    }

    @Override
    public EIndexAccessMode getAccessMode() {
        return this.indexAccess.value();
    }

    @Override
    protected String getToStringPrefix() {
        return "global index access: " + this.getIndexName();
    }
}

