/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.trigger;

import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepBranchingLayerAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepDeltaSource;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepGlobalIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccessBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepInitializer;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepMemberAccessorBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepParameter;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.EStorageAccessAttribute;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerTopSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.lib.commons.collections.PairList;

public class TriggerCompiler {
    public static final String BLOCK_IDENTIFIER_PREFIX = "#!";
    private final IndexSchema projectSchema;
    private final IndexSchema globalSchema;

    public TriggerCompiler(IndexSchema projectSchema, IndexSchema globalSchema) {
        this.projectSchema = projectSchema;
        this.globalSchema = globalSchema;
    }

    public List<AnalysisTrigger> compile(PairList<String, TriggerDescription> triggerDescriptions) throws TriggerCompilationException {
        ArrayList<AnalysisTrigger> compiledTriggers = new ArrayList<AnalysisTrigger>();
        for (int i = 0; i < triggerDescriptions.size(); ++i) {
            compiledTriggers.add(this.compile((String)triggerDescriptions.getFirst(i), (TriggerDescription)triggerDescriptions.getSecond(i)));
        }
        new TriggerTopSorter(compiledTriggers, this.projectSchema).calculateExecutionOrder();
        return compiledTriggers;
    }

    public AnalysisTrigger compile(String triggerName, TriggerDescription triggerDescription) throws TriggerCompilationException {
        Class<? extends IAnalysisStep> stepClass = triggerDescription.getTriggerClass();
        if (!AnalysisStepBase.class.isAssignableFrom(stepClass)) {
            throw new TriggerCompilationException("Expected step class " + String.valueOf(stepClass) + " to extend " + String.valueOf(AnalysisStepBase.class));
        }
        Class<AnalysisStepBase> analysisStepClass = stepClass.asSubclass(AnalysisStepBase.class);
        AnalysisStepInitializer blockInitializer = new AnalysisStepInitializer(analysisStepClass);
        AnalysisTrigger trigger = new AnalysisTrigger(triggerName, triggerDescription, blockInitializer, analysisStepClass);
        this.fillStoresAndDeltas(trigger, triggerDescription);
        TriggerCompiler.checkParameterConsistency(trigger);
        return trigger;
    }

    private void fillStoresAndDeltas(AnalysisTrigger compiledTrigger, TriggerDescription triggerDescription) throws TriggerCompilationException {
        AnalysisStepInitializer analysisStepInitializer = compiledTrigger.getAnalysisStepInitializer();
        for (List<AnalysisStepIndexAccess> list : analysisStepInitializer.getIndexAccesses().values()) {
            for (AnalysisStepIndexAccess analysisStepIndexAccess : list) {
                this.fillFromIndexAccess(compiledTrigger, analysisStepIndexAccess);
            }
        }
        for (List<AnalysisStepIndexAccessBase> list : analysisStepInitializer.getGlobalIndexAccesses().values()) {
            for (AnalysisStepGlobalIndexAccess analysisStepGlobalIndexAccess : list) {
                this.fillFromGlobalIndexAccess(compiledTrigger, analysisStepGlobalIndexAccess);
            }
        }
        for (AnalysisStepBranchingLayerAccess analysisStepBranchingLayerAccess : analysisStepInitializer.getBranchingLayerAccesses()) {
            compiledTrigger.addStorageAccess(EStorageAccessAttribute.BRANCHING_LAYER_ATTRIBUTE_NAME, analysisStepBranchingLayerAccess.getIndexName(), false);
        }
        for (AnalysisStepDeltaSource analysisStepDeltaSource : analysisStepInitializer.getDeltaSources()) {
            compiledTrigger.addStorageAccess(EStorageAccessAttribute.DELTA_ATTRIBUTE_NAME, analysisStepDeltaSource.getIndexName(), TriggerCompiler.isVirtualIndex(analysisStepDeltaSource.getIndexClass()));
        }
        HashSet<AnalysisStepParameter> missingParameters = new HashSet<AnalysisStepParameter>();
        for (AnalysisStepParameter parameter : analysisStepInitializer.getAnalysisStepParameters()) {
            Optional<TriggerDescription.Parameter<String>> optional = triggerDescription.getTriggerParameters().getParameter(parameter.getName());
            if (optional.isEmpty()) {
                if (parameter.isOptional()) continue;
                missingParameters.add(parameter);
                continue;
            }
            parameter.parseValue(optional.get());
        }
        if (!missingParameters.isEmpty()) {
            throw new TriggerCompilationException("Expected parameter(s) for { " + missingParameters.stream().map(AnalysisStepMemberAccessorBase::toString).collect(Collectors.joining(", ")) + " } in " + compiledTrigger.getName());
        }
    }

    private void fillFromIndexAccess(AnalysisTrigger compiledTrigger, AnalysisStepIndexAccess indexAccess) throws TriggerCompilationException {
        String storeName = compiledTrigger.renameStoreName(indexAccess.getIndexName());
        Class<? extends IStorageIndex> actualIndexType = TriggerCompiler.checkStoreExistenceAndType(storeName, indexAccess.getIndexClass(), compiledTrigger.getName(), this.projectSchema);
        boolean virtual = TriggerCompiler.isVirtualIndex(actualIndexType);
        EStorageAccessAttribute storageAccessAttribute = switch (indexAccess.getAccessMode()) {
            default -> throw new MatchException(null, null);
            case EIndexAccessMode.READ_ONLY -> EStorageAccessAttribute.READ_ONLY_INDEX_ATTRIBUTE_NAME;
            case EIndexAccessMode.READ_WRITE -> {
                if (indexAccess.isSkipDeltaCreation()) {
                    yield EStorageAccessAttribute.READ_ONLY_INDEX_ATTRIBUTE_NAME;
                }
                yield EStorageAccessAttribute.READ_WRITE_INDEX_ATTRIBUTE_NAME;
            }
            case EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY -> {
                this.ensureHistorized(compiledTrigger, storeName);
                yield EStorageAccessAttribute.READ_ONLY_PREVIOUS_INDEX_ATTRIBUTE_NAME;
            }
            case EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY -> {
                this.ensureHistorized(compiledTrigger, storeName);
                yield EStorageAccessAttribute.READ_ONLY_ALL_PARENT_INDEXES_ATTRIBUTE_NAME;
            }
        };
        compiledTrigger.addStorageAccess(storageAccessAttribute, storeName, virtual);
    }

    private void ensureHistorized(AnalysisTrigger compiledTrigger, String storeName) throws TriggerCompilationException {
        if (!this.projectSchema.getEntry(storeName).isHistorized()) {
            throw new TriggerCompilationException("Store " + storeName + " is accessed by trigger " + compiledTrigger.getName() + " in the previous revision but is not historized!");
        }
    }

    private void fillFromGlobalIndexAccess(AnalysisTrigger compiledTrigger, AnalysisStepGlobalIndexAccess globalIndexAccess) throws TriggerCompilationException {
        String storeName = globalIndexAccess.getIndexName();
        TriggerCompiler.checkStoreExistenceAndType(storeName, globalIndexAccess.getIndexClass(), compiledTrigger.getName(), this.globalSchema);
        boolean virtual = false;
        switch (globalIndexAccess.getAccessMode()) {
            case READ_ONLY: {
                compiledTrigger.addStorageAccess(EStorageAccessAttribute.READ_ONLY_GLOBAL_STORE_ATTRIBUTE_NAME, storeName, virtual);
                break;
            }
            case READ_WRITE: {
                compiledTrigger.addStorageAccess(EStorageAccessAttribute.READ_WRITE_GLOBAL_STORE_ATTRIBUTE_NAME, storeName, virtual);
                break;
            }
            case PREVIOUS_REVISION_READ_ONLY: 
            case ALL_PARENT_REVISIONS_READ_ONLY: {
                throw new TriggerCompilationException("Unsupported mode " + String.valueOf((Object)globalIndexAccess.getAccessMode()) + " for global index access of " + storeName);
            }
            default: {
                throw new AssertionError((Object)("Unknown mode: " + String.valueOf((Object)globalIndexAccess.getAccessMode())));
            }
        }
    }

    private static void checkParameterConsistency(AnalysisTrigger compiledTrigger) throws TriggerCompilationException {
        if (compiledTrigger.isPeriodic()) {
            TriggerCompiler.assertCondition(compiledTrigger, compiledTrigger.getExpectedDeltaStoreNames().isEmpty(), "A periodic trigger may not depend on deltas!");
        }
        if (compiledTrigger.isRunToExhaustion()) {
            TriggerCompiler.assertCondition(compiledTrigger, compiledTrigger.isPeriodic(), ESchedulingParameter.RUN_TO_EXHAUSTION.getParameterName() + " may only be set for periodic triggers!");
        }
        if (compiledTrigger.getExpectedDeltaStoreNames().size() > 1) {
            TriggerCompiler.assertCondition(compiledTrigger, compiledTrigger.isMergeInputDeltas(), String.valueOf((Object)EAnalysisStepParameter.MERGE_INPUT_DELTAS) + " scheduling hint must be used for all triggers consuming multiple store deltas!");
        }
        TriggerCompiler.checkOverlappingStoreAccess(compiledTrigger);
    }

    private static void checkOverlappingStoreAccess(AnalysisTrigger compiledTrigger) throws TriggerCompilationException {
        int expectedSize = 0;
        expectedSize += compiledTrigger.getReadOnlyStores().size();
        HashSet<String> allStores = new HashSet<String>((Collection<String>)compiledTrigger.getReadOnlyStores());
        expectedSize += compiledTrigger.getReadBranchingLayerStores().size();
        allStores.addAll((Collection<String>)compiledTrigger.getReadBranchingLayerStores());
        allStores.addAll((Collection<String>)compiledTrigger.getWriteStores());
        TriggerCompiler.assertCondition(compiledTrigger, allStores.size() == (expectedSize += compiledTrigger.getWriteStores().size()), "Some stores are accessed using different read/write access!");
    }

    private static void assertCondition(AnalysisTrigger compiledTrigger, boolean condition, String message) throws TriggerCompilationException {
        if (!condition) {
            throw new TriggerCompilationException("Trigger " + compiledTrigger.getName() + " violates consistency condition: " + message);
        }
    }

    private static Class<? extends IStorageIndex> checkStoreExistenceAndType(String storeName, Class<? extends IStorageIndex> indexType, String triggerName, IndexSchema schema) throws TriggerCompilationException {
        Class<?> schemaIndexClass;
        SchemaEntry schemaEntry = schema.getEntry(storeName);
        if (schemaEntry == null) {
            throw new TriggerCompilationException("Store " + storeName + " required by trigger " + triggerName + " not found in project");
        }
        try {
            schemaIndexClass = Class.forName(schemaEntry.getIndexClass());
        }
        catch (ClassNotFoundException e) {
            throw new TriggerCompilationException("Trigger " + triggerName + " required index " + storeName + ". But the schema index class " + schemaEntry.getIndexClass() + " could not be loaded", e);
        }
        if (!indexType.isAssignableFrom(schemaIndexClass)) {
            throw new TriggerCompilationException("Trigger " + triggerName + " required index " + storeName + " to be of type " + String.valueOf(indexType) + ", but project provides type " + String.valueOf(schemaIndexClass));
        }
        return schemaIndexClass.asSubclass(IStorageIndex.class);
    }

    private static boolean isVirtualIndex(Class<? extends IStorageIndex> indexClass) {
        Index indexAnnotation = IStorageIndex.getIndexAnnotation(indexClass);
        return Arrays.asList(indexAnnotation.options()).contains(EStorageOption.VIRTUAL);
    }
}

