/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public class ProjectSchedulingFilter
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="schedulingMode")
    private ESchedulingMode schedulingMode = ESchedulingMode.ALL;
    @JsonProperty(value="pausedProjects")
    private final Set<IProjectId> pausedProjects = new HashSet<IProjectId>();

    public void setSchedulingMode(ESchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    private boolean pauseProject(InternalProjectId projectId) {
        return this.pausedProjects.add((IProjectId)projectId);
    }

    private boolean resumeProject(InternalProjectId projectId) {
        return this.pausedProjects.remove(projectId);
    }

    public boolean isSchedulable(InternalProjectId projectId) {
        return switch (this.schedulingMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (!this.pausedProjects.contains(projectId)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> SchedulingConstants.isMaintenance((IProjectId)projectId);
            case 2 -> false;
        };
    }

    public ESchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    public void retainOnlyVisibleProjects(Collection<InternalProjectId> visibleProjectIds) {
        this.pausedProjects.retainAll(visibleProjectIds);
    }

    public static boolean resumeProjectIfPaused(InternalProjectId projectName, GlobalStorageSystem globalStorageSystem) throws StorageException {
        return ProjectSchedulingFilter.modifyProjectSchedulingFilter(globalStorageSystem, projectSchedulingFilter -> projectSchedulingFilter.resumeProject(projectName));
    }

    public static boolean pauseProject(InternalProjectId projectName, GlobalStorageSystem globalStorageSystem) throws StorageException {
        return ProjectSchedulingFilter.modifyProjectSchedulingFilter(globalStorageSystem, projectSchedulingFilter -> projectSchedulingFilter.pauseProject(projectName));
    }

    public static void setSchedulerMode(@NonNull ESchedulingMode schedulingMode, @NonNull GlobalStorageSystem globalStorageSystem, @NonNull String logMessage) throws StorageException {
        ProjectSchedulingFilter.modifyProjectSchedulingFilter(globalStorageSystem, filter -> {
            filter.setSchedulingMode(schedulingMode);
            return null;
        });
        LOGGER.info("Scheduler mode changed to '{}', reason: {}", (Object)schedulingMode.toString(), (Object)logMessage);
    }

    private static <T> T modifyProjectSchedulingFilter(GlobalStorageSystem globalStorageSystem, Function<ProjectSchedulingFilter, T> schedulingFilterConsumer) throws StorageException {
        WorkerIndex workerIndex = (WorkerIndex)globalStorageSystem.openGlobalIndex(WorkerIndex.class);
        return workerIndex.getSchedulingFilterAccess().modify(schedulingFilterConsumer);
    }

    public ProjectSchedulingFilter replaceInternalIdsByPublicIds(List<ProjectInfo> visibleProjects) {
        ProjectSchedulingFilter projectSchedulingFilter = new ProjectSchedulingFilter();
        projectSchedulingFilter.setSchedulingMode(this.schedulingMode);
        Set<IProjectId> projectIds = visibleProjects.stream().filter(visibleProject -> this.pausedProjects.contains(visibleProject.getInternalId())).map(ProjectInfo::getPrimaryPublicId).collect(Collectors.toSet());
        projectSchedulingFilter.addPausedProjects(projectIds);
        return projectSchedulingFilter;
    }

    private void addPausedProjects(Set<IProjectId> projectIds) {
        this.pausedProjects.addAll(projectIds);
    }

    public String toString() {
        return "ProjectSchedulingFilter{schedulingMode=" + String.valueOf((Object)this.schedulingMode) + ", pausedProjects=" + String.valueOf(this.pausedProjects) + "}";
    }

    @ExportToTypeScript
    @IndexValueClass
    public static enum ESchedulingMode {
        ALL("all jobs"),
        MAINTENANCE_ONLY("maintenance jobs only"),
        PAUSED("no jobs");

        @JsonProperty(value="readableName")
        private final String readableName;

        private ESchedulingMode(String readableName) {
            this.readableName = readableName;
        }

        public String toString() {
            return this.name() + " ('" + this.readableName + "')";
        }
    }
}

