/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.google.common.base.Preconditions;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.performance.PerformanceMetricsIndex;
import com.teamscale.core.runtime.impl.scheduling.SchedulingData;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.core.shutdown.ShutdownManagerAwareThread;
import io.prometheus.metrics.core.datapoints.GaugeDataPoint;
import io.prometheus.metrics.core.metrics.Gauge;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.concurrent.ThreadUtils;
import org.conqat.lib.commons.date.DurationUtils;

public class ClusterStatusThread
extends ShutdownManagerAwareThread {
    private static final Duration AVAILABILITY_REPORTING_DELAY = Duration.ofMillis(200L);
    private static final Duration MIN_REPORTING = Duration.ofSeconds(5L);
    private static final Duration REGULAR_REPORTING = Duration.ofMillis(WorkerIndex.ONE_OF_MANY_NODES_MAX_AGE.toMillis() / 2L);
    private static final Logger LOGGER = LogManager.getLogger();
    private final WorkerIndex workerIndex;
    private final PerformanceMetricsIndex performanceMetricsIndex;
    private final WorkerClusterStatus clusterStatus;
    private final SchedulingData schedulingData;
    private static final Gauge JOB_QUEUE_GAUGE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("job_queue_size_all")).labelNames(new String[]{"process"})).help("Number of jobs in the job queue.")).register();
    private static final Gauge JOB_QUEUE_DELAYED_GAUGE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("job_queue_size_delayed")).labelNames(new String[]{"process"})).help("Number of delayed jobs in the job queue.")).register();

    public ClusterStatusThread(WorkerClusterStatus clusterStatus, IndexLayer indexLayer, SchedulingData schedulingData) throws StorageException {
        this.clusterStatus = (WorkerClusterStatus)Preconditions.checkNotNull((Object)clusterStatus);
        this.schedulingData = (SchedulingData)Preconditions.checkNotNull((Object)schedulingData);
        this.workerIndex = ((IndexLayer)Preconditions.checkNotNull((Object)indexLayer)).openGlobalIndex(WorkerIndex.class);
        this.performanceMetricsIndex = ((IndexLayer)Preconditions.checkNotNull((Object)indexLayer)).openGlobalIndex(PerformanceMetricsIndex.class);
        this.setPriority(5);
        this.setDaemon(true);
    }

    @Override
    protected void loop() {
        ThreadUtils.sleep((long)AVAILABILITY_REPORTING_DELAY.toMillis());
        if (!this.isInterrupted()) {
            boolean instantReporting = this.schedulingData.isProgressReportingNeeded() && DurationUtils.elapsed((Duration)MIN_REPORTING, (long)this.clusterStatus.getLastRefreshed());
            boolean regularReporting = DurationUtils.elapsed((Duration)REGULAR_REPORTING, (long)this.clusterStatus.getLastRefreshed());
            if (instantReporting || regularReporting) {
                this.reportClusterNodeAvailability();
            }
        }
    }

    private void reportClusterNodeAvailability() {
        try {
            ((GaugeDataPoint)JOB_QUEUE_GAUGE.labelValues(new String[]{this.clusterStatus.getProcessId()})).set((double)this.schedulingData.getOverallJobQueueSize());
            ((GaugeDataPoint)JOB_QUEUE_DELAYED_GAUGE.labelValues(new String[]{this.clusterStatus.getProcessId()})).set((double)this.schedulingData.getOverallDelayedJobQueueSize());
            this.clusterStatus.prepareDataForPersistence(this.schedulingData.getOverallJobQueueSize());
            this.workerIndex.getWorkerClusterStatusAccess().persistClusterStatus(this.clusterStatus);
            this.performanceMetricsIndex.recordMetrics(System.currentTimeMillis(), this.clusterStatus, this.schedulingData.getCompletedRevisionSupport());
        }
        catch (StorageException storageException) {
            LOGGER.error("Error writing system state (heartbeat): " + storageException.getMessage(), (Throwable)storageException);
        }
    }
}

