/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs.wiql;

import com.teamscale.core.tfs.wiql.EWiqlWhereClauseCombinator;
import com.teamscale.core.tfs.wiql.WiqlWhereClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class CombinedWiqlWhereClause
extends WiqlWhereClause {
    private final List<WiqlWhereClause> clauses;
    private final EWiqlWhereClauseCombinator combinator;

    public CombinedWiqlWhereClause(Collection<? extends WiqlWhereClause> clauses, EWiqlWhereClauseCombinator combinator) {
        this.clauses = new ArrayList<WiqlWhereClause>(Objects.requireNonNull(clauses, "clauses"));
        this.combinator = Objects.requireNonNull(combinator, "combinator");
    }

    @Override
    protected boolean isValid() {
        return this.clauses.stream().allMatch(WiqlWhereClause::isValid);
    }

    @Override
    protected boolean isEmpty() {
        return this.clauses.stream().allMatch(WiqlWhereClause::isEmpty);
    }

    @Override
    protected String toWiqlString() {
        List<String> clauses = this.clauses.stream().filter(Predicate.not(WiqlWhereClause::isEmpty)).map(WiqlWhereClause::toWiqlString).toList();
        if (clauses.size() == 1) {
            return clauses.get(0);
        }
        return clauses.stream().collect(Collectors.joining(" " + this.combinator.wiqlValue() + " ", "(", ")"));
    }

    @Override
    public CombinedWiqlWhereClause negated() {
        return new CombinedWiqlWhereClause(this.clauses.stream().map(WiqlWhereClause::negated).toList(), this.combinator.negated());
    }
}

