/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S5713")
public class ChildAndParentExceptionCaughtCheck
extends PHPVisitorCheck {
    private static final String MESSAGE_DERIVATIVE = "Remove this useless Exception class; it derives from class %s which is already caught.";
    private static final String MESSAGE_DUPLICATE = "Remove this duplicate Exception class.";
    private static final String SECONDARY_MESSAGE_DERIVATIVE = "Parent class.";
    private static final String SECONDARY_MESSAGE_DUPLICATE = "Duplicate.";

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        if (tree.exceptionTypes().size() > 1) {
            HashMap<ClassSymbol, List<NamespaceNameTree>> caughtExceptionsBySymbol = new HashMap<ClassSymbol, List<NamespaceNameTree>>();
            tree.exceptionTypes().forEach(e -> ChildAndParentExceptionCaughtCheck.addException(e, caughtExceptionsBySymbol));
            this.checkCaughtExceptions(caughtExceptionsBySymbol);
        }
        super.visitCatchBlock(tree);
    }

    private void checkCaughtExceptions(Map<ClassSymbol, List<NamespaceNameTree>> caughtExceptionsBySymbol) {
        caughtExceptionsBySymbol.forEach((currentSymbol, caughtExceptionsWithSameSymbol) -> {
            PreciseIssue issue;
            NamespaceNameTree currentException = (NamespaceNameTree)caughtExceptionsWithSameSymbol.get(0);
            if (caughtExceptionsWithSameSymbol.size() > 1) {
                issue = this.context().newIssue(this, currentException, MESSAGE_DUPLICATE);
                caughtExceptionsWithSameSymbol.stream().skip(1L).forEach(e -> issue.secondary((Tree)e, SECONDARY_MESSAGE_DUPLICATE));
            }
            issue = null;
            for (Map.Entry otherException : caughtExceptionsBySymbol.entrySet()) {
                ClassSymbol comparedSymbol = (ClassSymbol)otherException.getKey();
                if (currentSymbol == comparedSymbol || !currentSymbol.isSubTypeOf(comparedSymbol.qualifiedName()).isTrue()) continue;
                if (issue == null) {
                    issue = this.context().newIssue(this, currentException, String.format(MESSAGE_DERIVATIVE, comparedSymbol.qualifiedName().toString()));
                }
                ChildAndParentExceptionCaughtCheck.addSecondaryLocations(issue, (List)otherException.getValue());
            }
        });
    }

    private static void addException(NamespaceNameTree exception, Map<ClassSymbol, List<NamespaceNameTree>> caughtExceptionsByFQN) {
        ClassSymbol classSymbol = Symbols.getClass(exception);
        caughtExceptionsByFQN.computeIfAbsent(classSymbol, k -> new ArrayList()).add(exception);
    }

    private static void addSecondaryLocations(PreciseIssue issue, List<NamespaceNameTree> others) {
        for (NamespaceNameTree other : others) {
            issue.secondary(other, SECONDARY_MESSAGE_DERIVATIVE);
        }
    }
}

