/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2115")
public class EmptyDatabasePasswordCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2115";
    private static final String MESSAGE = "Add password protection to this database.";

    @Override
    public void visitFunctionCall(FunctionCallTree functionCall) {
        String functionName = CheckUtils.getLowerCaseFunctionName(functionCall);
        if ("mysqli".equals(functionName) || "mysqli_connect".equals(functionName) || "PDO".equalsIgnoreCase(functionName)) {
            this.checkPasswordArgument(functionCall, "passwd", 2);
        } else if ("oci_connect".equals(functionName)) {
            this.checkPasswordArgument(functionCall, "password", 1);
        } else if ("sqlsrv_connect".equals(functionName)) {
            this.checkSqlServer(functionCall);
        } else if ("pg_connect".equals(functionName)) {
            this.checkPostgresql(functionCall);
        }
        super.visitFunctionCall(functionCall);
    }

    private void checkPasswordArgument(FunctionCallTree functionCall, String argumentName, int argumentIndex) {
        ExpressionTree passwordArgument;
        Optional<CallArgumentTree> argument = CheckUtils.argument(functionCall, argumentName, argumentIndex);
        if (argument.isPresent() && this.hasEmptyValue(passwordArgument = argument.get().value())) {
            this.context().newIssue(this, passwordArgument, MESSAGE);
        }
    }

    private static boolean isEmptyLiteral(ExpressionTree expression) {
        if (expression.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            LiteralTree literal = (LiteralTree)expression;
            return literal.value().length() == 2;
        }
        return false;
    }

    private boolean hasEmptyValue(ExpressionTree expression) {
        if (EmptyDatabasePasswordCheck.isEmptyLiteral(expression)) {
            return true;
        }
        if (expression.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            return CheckUtils.uniqueAssignedValue((VariableIdentifierTree)expression).map(EmptyDatabasePasswordCheck::isEmptyLiteral).orElse(false);
        }
        return false;
    }

    private void checkSqlServer(FunctionCallTree functionCall) {
        ExpressionTree connectionInfo;
        ExpressionTree password;
        Optional<CallArgumentTree> argument = CheckUtils.argument(functionCall, "connectionInfo", 1);
        if (argument.isPresent() && (password = this.sqlServerPassword(connectionInfo = argument.get().value())) != null && this.hasEmptyValue(password)) {
            this.context().newIssue(this, password, MESSAGE);
        }
    }

    private ExpressionTree sqlServerPassword(ExpressionTree connectionInfo) {
        if (connectionInfo.is(Tree.Kind.ARRAY_INITIALIZER_FUNCTION, Tree.Kind.ARRAY_INITIALIZER_BRACKET)) {
            for (ArrayPairTree arrayPairTree : ((ArrayInitializerTree)connectionInfo).arrayPairs()) {
                ExpressionTree key = arrayPairTree.key();
                if (key == null || !key.is(Tree.Kind.REGULAR_STRING_LITERAL) || !"PWD".equals(CheckUtils.trimQuotes((LiteralTree)key))) continue;
                return arrayPairTree.value();
            }
            return null;
        }
        if (connectionInfo.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            return CheckUtils.uniqueAssignedValue((VariableIdentifierTree)connectionInfo).map(this::sqlServerPassword).orElse(null);
        }
        return null;
    }

    private void checkPostgresql(FunctionCallTree functionCall) {
        Optional<CallArgumentTree> connectionStringArgument = CheckUtils.argument(functionCall, "connection_string", 0);
        if (!connectionStringArgument.isPresent()) {
            return;
        }
        ExpressionTree connectionString = connectionStringArgument.get().value();
        if (connectionString.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            connectionString = CheckUtils.uniqueAssignedValue((VariableIdentifierTree)connectionString).orElse(connectionString);
        }
        this.checkPostgresqlConnectionString(connectionString);
    }

    private void checkPostgresqlConnectionString(ExpressionTree connectionString) {
        ArrayList<ExpressionTree> concatenationOperands = new ArrayList<ExpressionTree>();
        if (connectionString.is(Tree.Kind.CONCATENATION)) {
            EmptyDatabasePasswordCheck.concatenationOperands(connectionString, concatenationOperands);
        } else {
            concatenationOperands.add(connectionString);
        }
        ExpressionTree connectionStringLastPart = (ExpressionTree)concatenationOperands.get(concatenationOperands.size() - 1);
        Pattern noPasswordPattern = Pattern.compile(".*password\\s*=\\s*");
        Pattern emptyPasswordPattern = Pattern.compile(noPasswordPattern.pattern() + "''.*");
        if (concatenationOperands.stream().anyMatch(e -> EmptyDatabasePasswordCheck.isStringLiteralMatching(emptyPasswordPattern, e)) || EmptyDatabasePasswordCheck.isStringLiteralMatching(noPasswordPattern, connectionStringLastPart)) {
            this.context().newIssue(this, connectionString, MESSAGE);
        }
    }

    private static boolean isStringLiteralMatching(Pattern pattern, ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            return pattern.matcher(CheckUtils.trimQuotes((LiteralTree)expressionTree)).matches();
        }
        return false;
    }

    private static void concatenationOperands(ExpressionTree expression, List<ExpressionTree> operands) {
        if (expression.is(Tree.Kind.CONCATENATION)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)expression;
            EmptyDatabasePasswordCheck.concatenationOperands(binary.leftOperand(), operands);
            EmptyDatabasePasswordCheck.concatenationOperands(binary.rightOperand(), operands);
        } else {
            operands.add(expression);
        }
    }
}

