/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2068")
public class HardCodedCredentialsInVariablesAndUrisCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Detected '%s' in this variable name, review this potentially hardcoded credential.";
    private static final String MESSAGE_URI = "Detected URI with password, review this potentially hardcoded credential.";
    private static final String DEFAULT_CREDENTIAL_WORDS = "password,passwd,pwd";
    private static final String LITERAL_PATTERN_SUFFIX = "=(?!([\\?:']|%s))..";
    private static final int LITERAL_PATTERN_SUFFIX_LENGTH = "=(?!([\\?:']|%s))..".length();
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd")
    public String credentialWords = "password,passwd,pwd";
    private List<Pattern> variablePatterns = null;
    private List<Pattern> literalPatterns = null;

    private Stream<Pattern> variablePatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            this.literalPatterns = this.toPatterns(LITERAL_PATTERN_SUFFIX);
        }
        return this.literalPatterns.stream();
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.credentialWords.split(",")).map(String::trim).map(word -> Pattern.compile(word + suffix, 2)).toList();
    }

    @Override
    public void visitLiteral(LiteralTree literal) {
        this.checkForCredentialQuery(literal);
        this.checkForCredentialUri(literal);
        super.visitLiteral(literal);
    }

    private void checkForCredentialQuery(LiteralTree literal) {
        this.literalPatterns().filter(pattern -> pattern.matcher(literal.token().text()).find()).findAny().ifPresent(pattern -> this.addIssue((Pattern)pattern, literal));
    }

    private void checkForCredentialUri(LiteralTree literal) {
        URI uri;
        String possibleUrl = CheckUtils.trimQuotes(literal.value());
        try {
            uri = new URI(possibleUrl);
        }
        catch (URISyntaxException e) {
            return;
        }
        if (uri.getUserInfo() != null) {
            String userInfo = uri.getUserInfo();
            String[] splitUserInfo = userInfo.split(":");
            if (splitUserInfo.length < 2 || splitUserInfo[0].equals(splitUserInfo[1]) || HardCodedCredentialsInVariablesAndUrisCheck.isCommonTestCredential(userInfo)) {
                return;
            }
            this.context().newIssue(this, literal, MESSAGE_URI);
        }
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree declaration) {
        this.checkVariable(declaration.identifier().token(), declaration.initValue());
        super.visitVariableDeclaration(declaration);
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        this.checkVariable(((PHPTree)((Object)assignment.variable())).getLastToken(), assignment.value());
        super.visitAssignmentExpression(assignment);
    }

    private void checkVariable(SyntaxToken reportTree, @Nullable Tree assignedValue) {
        if (assignedValue != null && assignedValue.is(Tree.Kind.REGULAR_STRING_LITERAL) && !HardCodedCredentialsInVariablesAndUrisCheck.isEmptyStringLiteral((LiteralTree)assignedValue)) {
            this.variablePatterns().filter(pattern -> pattern.matcher(reportTree.text()).find()).findAny().ifPresent(pattern -> this.checkAssignedValue((Pattern)pattern, reportTree, assignedValue));
        }
    }

    private void checkAssignedValue(Pattern pattern, SyntaxToken reportTree, Tree assignedValue) {
        if (!pattern.matcher(assignedValue.toString()).find()) {
            this.addIssue(pattern, reportTree);
        }
    }

    private static boolean isEmptyStringLiteral(LiteralTree literal) {
        return literal.value().substring(1, literal.value().length() - 1).isEmpty();
    }

    private void addIssue(Pattern pattern, Tree tree) {
        this.context().newIssue(this, tree, String.format(MESSAGE, HardCodedCredentialsInVariablesAndUrisCheck.cleanedPattern(pattern.pattern())));
    }

    private static String cleanedPattern(String pattern) {
        if (pattern.endsWith(LITERAL_PATTERN_SUFFIX)) {
            return pattern.substring(0, pattern.length() - LITERAL_PATTERN_SUFFIX_LENGTH);
        }
        return pattern;
    }

    private static boolean isCommonTestCredential(String userInfo) {
        return "user:password".equals(userInfo) || "username:password".equals(userInfo);
    }
}

