/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S114")
public class InterfaceNameCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S114";
    private static final String MESSAGE = "Rename this interface name to match the regular expression %s.";
    public static final String DEFAULT_FORMAT = "^[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the interface names against.", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    public String format = "^[A-Z][a-zA-Z0-9]*$";

    @Override
    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.INTERFACE_DECLARATION);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassDeclarationTree declaration = (ClassDeclarationTree)tree;
        String name = declaration.name().text();
        if (!this.pattern.matcher(name).matches()) {
            this.context().newIssue(this, declaration.name(), String.format(MESSAGE, this.format));
        }
    }
}

