/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1940")
public class InvertedBooleanCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Use the opposite operator '%s' instead and remove complement operator.";
    private static final Tree.Kind[] BINARY_EXPRESSION = new Tree.Kind[]{Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO};
    private final Map<String, String> operatorReplacements = new HashMap<String, String>();

    public InvertedBooleanCheck() {
        this.operatorReplacements.put("<", ">=");
        this.operatorReplacements.put(">", "<=");
        this.operatorReplacements.put("==", "!=");
        this.operatorReplacements.put("===", "!==");
        this.operatorReplacements.put("<=", ">");
        this.operatorReplacements.put(">=", "<");
        this.operatorReplacements.put("!=", "==");
        this.operatorReplacements.put("!==", "===");
    }

    @Override
    public void visitPrefixExpression(UnaryExpressionTree tree) {
        if (tree.is(Tree.Kind.LOGICAL_COMPLEMENT)) {
            this.checkComplementParenthesisedExpression(tree, tree.expression());
        }
        super.visitPrefixExpression(tree);
    }

    private void checkComplementParenthesisedExpression(UnaryExpressionTree tree, ExpressionTree expression) {
        if (expression.is(BINARY_EXPRESSION)) {
            String operator = ((BinaryExpressionTree)expression).operator().text();
            this.context().newIssue(this, tree, String.format(MESSAGE, this.operatorReplacements.get(operator)));
        } else if (expression.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            this.checkComplementParenthesisedExpression(tree, ((ParenthesisedExpressionTree)expression).expression());
        }
    }
}

