/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S2038")
public class LowerCaseColorCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S2038";
    private static final String MESSAGE = "Replace \"%s\" with \"%s\".";
    private static final Pattern COLOR_REGEXP = Pattern.compile("#[A-Fa-f0-9]{3,6}");
    private static final Pattern COLOR_REGEXP_UPPER_CASE = Pattern.compile("#[A-F0-9]{3,6}");

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.REGULAR_STRING_LITERAL);
    }

    @Override
    public void visitNode(Tree tree) {
        String stringContent = LowerCaseColorCheck.getStringContent((LiteralTree)tree);
        if (LowerCaseColorCheck.isLowerCaseColor(stringContent)) {
            String message = String.format(MESSAGE, stringContent, stringContent.toUpperCase(Locale.ENGLISH));
            this.context().newIssue(this, tree, message);
        }
    }

    private static boolean isLowerCaseColor(String str) {
        return COLOR_REGEXP.matcher(str).matches() && !COLOR_REGEXP_UPPER_CASE.matcher(str).matches();
    }

    private static String getStringContent(LiteralTree stringLiteral) {
        String stringContent = stringLiteral.value();
        return stringContent.substring(1, stringContent.length() - 1);
    }
}

