/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.visitors.CheckContext;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1697")
public class NullDereferenceInConditionalCheck
extends PHPVisitorCheck {
    private static final String MESSAGE_FORMAT = "Either reverse the equality operator in the \"%s\" null test, or reverse the logical operator that follows it.";
    private static final List<Tree.Kind> AND_KINDS = Arrays.asList(Tree.Kind.CONDITIONAL_AND, Tree.Kind.ALTERNATIVE_CONDITIONAL_AND);
    private static final List<Tree.Kind> OR_KINDS = Arrays.asList(Tree.Kind.CONDITIONAL_OR, Tree.Kind.ALTERNATIVE_CONDITIONAL_OR);

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        ExpressionTree comparedWithNullExpression = NullDereferenceInConditionalCheck.getComparedWithNullExpression(tree.leftOperand(), tree.getKind());
        if (comparedWithNullExpression != null) {
            tree.rightOperand().accept(new NullExpressionUsageVisitor(comparedWithNullExpression, this.context(), this));
        }
        super.visitBinaryExpression(tree);
    }

    @Nullable
    private static ExpressionTree getComparedWithNullExpression(ExpressionTree expression, Tree.Kind kind) {
        ExpressionTree comparedExpression = NullDereferenceInConditionalCheck.getExpressionEqualNullWithAnd(expression, kind);
        if (comparedExpression == null && (comparedExpression = NullDereferenceInConditionalCheck.getExpressionNotEqualNullWithOr(expression, kind)) == null) {
            comparedExpression = NullDereferenceInConditionalCheck.getExpressionComparedWithFunction(expression, kind);
        }
        return comparedExpression;
    }

    @Nullable
    private static ExpressionTree getExpressionEqualNullWithAnd(ExpressionTree tree, Tree.Kind kind) {
        if (AND_KINDS.contains(kind)) {
            return NullDereferenceInConditionalCheck.getComparedWithNull(tree, Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO);
        }
        return null;
    }

    @Nullable
    private static ExpressionTree getExpressionNotEqualNullWithOr(ExpressionTree tree, Tree.Kind kind) {
        if (OR_KINDS.contains(kind)) {
            return NullDereferenceInConditionalCheck.getComparedWithNull(tree, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO);
        }
        return null;
    }

    @Nullable
    private static ExpressionTree getExpressionComparedWithFunction(ExpressionTree expression, Tree.Kind kind) {
        if (OR_KINDS.contains(kind) && expression.is(Tree.Kind.LOGICAL_COMPLEMENT) && ((UnaryExpressionTree)expression).expression().is(Tree.Kind.FUNCTION_CALL)) {
            FunctionCallTree functionCall = (FunctionCallTree)((UnaryExpressionTree)expression).expression();
            return NullDereferenceInConditionalCheck.retrieveArgumentFromIsNullCall(functionCall);
        }
        if (AND_KINDS.contains(kind) && expression.is(Tree.Kind.FUNCTION_CALL)) {
            return NullDereferenceInConditionalCheck.retrieveArgumentFromIsNullCall((FunctionCallTree)expression);
        }
        return null;
    }

    @Nullable
    private static ExpressionTree retrieveArgumentFromIsNullCall(FunctionCallTree functionCall) {
        if ("is_null".equals(CheckUtils.getLowerCaseFunctionName(functionCall))) {
            return CheckUtils.argumentValue(functionCall, "value", 0).orElse(null);
        }
        return null;
    }

    @Nullable
    private static ExpressionTree getComparedWithNull(ExpressionTree expression, Tree.Kind kind1, Tree.Kind kind2) {
        ExpressionTree tree = NullDereferenceInConditionalCheck.removeParenthesis(expression);
        if (tree.is(kind1, kind2)) {
            BinaryExpressionTree binaryExp = (BinaryExpressionTree)tree;
            if (NullDereferenceInConditionalCheck.isNullLiteral(binaryExp.leftOperand())) {
                return NullDereferenceInConditionalCheck.removeParenthesis(binaryExp.rightOperand());
            }
            if (NullDereferenceInConditionalCheck.isNullLiteral(binaryExp.rightOperand())) {
                return NullDereferenceInConditionalCheck.removeParenthesis(binaryExp.leftOperand());
            }
        }
        return null;
    }

    private static ExpressionTree removeParenthesis(ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            return NullDereferenceInConditionalCheck.removeParenthesis(((ParenthesisedExpressionTree)expressionTree).expression());
        }
        return expressionTree;
    }

    private static boolean isNullLiteral(Tree tree) {
        return tree.is(Tree.Kind.NULL_LITERAL);
    }

    private static class NullExpressionUsageVisitor
    extends PHPVisitorCheck {
        private final NullDereferenceInConditionalCheck check;
        private ExpressionTree nullExpression;
        private CheckContext context;

        public NullExpressionUsageVisitor(ExpressionTree nullExpression, CheckContext context, NullDereferenceInConditionalCheck check) {
            this.nullExpression = nullExpression;
            this.context = context;
            this.check = check;
        }

        @Override
        public void visitMemberAccess(MemberAccessTree tree) {
            if (SyntacticEquivalence.areSyntacticallyEquivalent(NullDereferenceInConditionalCheck.removeParenthesis(tree.object()), this.nullExpression)) {
                this.context.newIssue(this.check, this.nullExpression, String.format(NullDereferenceInConditionalCheck.MESSAGE_FORMAT, this.nullExpression.toString()));
            }
            super.visitMemberAccess(tree);
        }
    }
}

