/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.metrics.LineVisitor;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1151")
public class SwitchCaseTooBigCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1151";
    private static final String MESSAGE = "Reduce this \"switch/case\" number of lines from %s to at most %s, for example by extracting code into function.";
    public static final int DEFAULT = 10;
    @RuleProperty(key="max", description="Maximum number of lines of code", defaultValue="10")
    int max = 10;

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        tree.cases().forEach(this::checkCaseClause);
        super.visitSwitchStatement(tree);
    }

    private void checkCaseClause(SwitchCaseClauseTree clause) {
        int lines = LineVisitor.linesOfCode(clause);
        if (lines > this.max) {
            this.context().newIssue(this, clause.caseToken(), String.format(MESSAGE, lines, this.max));
        }
    }
}

