/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1479")
public class TooManyCasesInSwitchCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1479";
    public static final int DEFAULT = 30;
    @RuleProperty(key="max", defaultValue="30")
    int max = 30;

    @Override
    public void visitSwitchStatement(SwitchStatementTree switchTree) {
        int numberOfCases = switchTree.cases().size();
        if (numberOfCases > this.max) {
            this.context().newIssue(this, switchTree.switchToken(), String.format("Reduce the number of switch cases from %s to at most %s.", numberOfCases, this.max));
        }
        super.visitSwitchStatement(switchTree);
    }
}

