/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1448")
public class TooManyMethodsInClassCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1448";
    private static final String MESSAGE = "Class \"%s\" has %s methods, which is greater than %s authorized. Split it into smaller classes.";
    private static final String MESSAGE_ANONYMOUS_CLASS = "This anonymous class has %s methods, which is greater than %s authorized. Split it into smaller classes.";
    private static final int DEFAULT_THRESHOLD = 20;
    private static final boolean DEFAULT_NON_PUBLIC = true;
    @RuleProperty(key="maximumMethodThreshold", defaultValue="20")
    public int maximumMethodThreshold = 20;
    @RuleProperty(key="countNonpublicMethods", defaultValue="true", type="BOOLEAN")
    public boolean countNonpublicMethods = true;

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        super.visitClassDeclaration(tree);
        if (tree.is(Tree.Kind.CLASS_DECLARATION, Tree.Kind.INTERFACE_DECLARATION)) {
            this.checkClass(tree);
        }
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        super.visitAnonymousClass(tree);
        this.checkClass(tree);
    }

    private void checkClass(ClassTree tree) {
        int nbMethod = this.getNumberOfMethods(tree);
        if (nbMethod > this.maximumMethodThreshold) {
            String message = tree.is(Tree.Kind.ANONYMOUS_CLASS) ? String.format(MESSAGE_ANONYMOUS_CLASS, nbMethod, this.maximumMethodThreshold) : String.format(MESSAGE, ((ClassDeclarationTree)tree).name().text(), nbMethod, this.maximumMethodThreshold);
            this.context().newIssue(this, tree.classToken(), message);
        }
    }

    private int getNumberOfMethods(ClassTree tree) {
        int nbMethod = 0;
        for (ClassMemberTree classMember : tree.members()) {
            if (!classMember.is(Tree.Kind.METHOD_DECLARATION) || this.isExcluded((MethodDeclarationTree)classMember)) continue;
            ++nbMethod;
        }
        return nbMethod;
    }

    private boolean isExcluded(MethodDeclarationTree tree) {
        if (!this.countNonpublicMethods) {
            for (SyntaxToken modifierToken : tree.modifiers()) {
                String modifier = modifierToken.text();
                if (!PHPKeyword.PROTECTED.getValue().equals(modifier) && !PHPKeyword.PRIVATE.getValue().equals(modifier)) continue;
                return true;
            }
        }
        return false;
    }
}

