/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S3984")
public class UnusedExceptionCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Throw this exception or remove this useless statement";
    private static final QualifiedName EXCEPTION_FQN = QualifiedName.qualifiedName("Exception");

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        if (tree.expression().is(Tree.Kind.NEW_EXPRESSION)) {
            NewExpressionTree newExpressionTree = (NewExpressionTree)tree.expression();
            ExpressionTree checkForException = newExpressionTree.expression();
            if (checkForException.is(Tree.Kind.FUNCTION_CALL)) {
                checkForException = ((FunctionCallTree)checkForException).callee();
            }
            if (checkForException.is(Tree.Kind.NAMESPACE_NAME) && Symbols.getClass((NamespaceNameTree)checkForException).isOrSubClassOf(EXCEPTION_FQN).isTrue()) {
                this.context().newIssue(this, newExpressionTree, MESSAGE);
            }
        }
        super.visitExpressionStatement(tree);
    }
}

