/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.ReadWriteUsages;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.utils.collections.MapBuilder;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S4423")
public class WeakSSLProtocolCheck
extends PHPVisitorCheck {
    public static final String KEY = "S4423";
    private static final String STREAM_CONTEXT_CREATE = "stream_context_create";
    private static final String STREAM_SOCKET_ENABLE_CRYPTO = "stream_socket_enable_crypto";
    private static final String CURL_SETOPT = "curl_setopt";
    private static final String CRYPTO_METHOD_KEY = "crypto_method";
    private static final Map<String, List<String>> STREAM_WEAK_PROTOCOLS = MapBuilder.builder().put("stream_context_create", Arrays.asList("STREAM_CRYPTO_METHOD_ANY_CLIENT", "STREAM_CRYPTO_METHOD_ANY_SERVER", "STREAM_CRYPTO_METHOD_TLSv1_0_CLIENT", "STREAM_CRYPTO_METHOD_TLSv1_0_SERVER", "STREAM_CRYPTO_METHOD_TLSv1_1_CLIENT", "STREAM_CRYPTO_METHOD_TLSv1_1_SERVER")).put("stream_socket_enable_crypto", Arrays.asList("STREAM_CRYPTO_METHOD_SSLv2_CLIENT", "STREAM_CRYPTO_METHOD_SSLv3_CLIENT", "STREAM_CRYPTO_METHOD_SSLv23_CLIENT", "STREAM_CRYPTO_METHOD_ANY_CLIENT", "STREAM_CRYPTO_METHOD_TLS_CLIENT", "STREAM_CRYPTO_METHOD_TLSv1_0_CLIENT", "STREAM_CRYPTO_METHOD_TLSv1_1_CLIENT", "STREAM_CRYPTO_METHOD_SSLv2_SERVER", "STREAM_CRYPTO_METHOD_SSLv3_SERVER", "STREAM_CRYPTO_METHOD_SSLv23_SERVER", "STREAM_CRYPTO_METHOD_ANY_SERVER", "STREAM_CRYPTO_METHOD_TLS_SERVER", "STREAM_CRYPTO_METHOD_TLSv1_0_SERVER", "STREAM_CRYPTO_METHOD_TLSv1_1_SERVER")).build();
    private static final List<String> CURL_WEAK_PROTOCOLS = Arrays.asList("CURL_SSLVERSION_TLSv1", "CURL_SSLVERSION_SSLv2", "CURL_SSLVERSION_SSLv3", "CURL_SSLVERSION_TLSv1_0", "CURL_SSLVERSION_TLSv1_1");
    private static final String MESSAGE = "Change this code to use a stronger protocol.";

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        if (STREAM_CONTEXT_CREATE.equals(functionName)) {
            CheckUtils.argument(tree, "options", 0).ifPresent(options -> this.checkStreamSSLConfig(options.value()));
        }
        if (STREAM_SOCKET_ENABLE_CRYPTO.equals(functionName)) {
            CheckUtils.argument(tree, "crypto_type", 2).ifPresent(cryptoType -> this.checkStreamWeakProtocol(WeakSSLProtocolCheck.getAssignedValue(cryptoType.value()), STREAM_SOCKET_ENABLE_CRYPTO));
        }
        if (CURL_SETOPT.equals(functionName)) {
            ExpressionTree optionArgumentValue;
            Optional<CallArgumentTree> optionArgument = CheckUtils.argument(tree, "option", 1);
            Optional<CallArgumentTree> valueArgument = CheckUtils.argument(tree, "value", 2);
            if (optionArgument.isPresent() && valueArgument.isPresent() && (optionArgumentValue = optionArgument.get().value()).is(Tree.Kind.NAMESPACE_NAME) && "CURLOPT_SSLVERSION".equals(((NamespaceNameTree)optionArgumentValue).name().text())) {
                this.checkCURLWeakProtocol(WeakSSLProtocolCheck.getAssignedValue(valueArgument.get().value()));
            }
        }
        super.visitFunctionCall(tree);
    }

    private void checkStreamSSLConfig(ExpressionTree expressionTree) {
        ReadWriteUsages usages;
        boolean hasSensitiveReassignment;
        Tree enclosingBlock = TreeUtils.findAncestorWithKind((Tree)expressionTree, Tree.Kind.BLOCK);
        if (enclosingBlock != null && (hasSensitiveReassignment = this.checkOptionsReassignment(usages = new ReadWriteUsages(enclosingBlock, this.context().symbolTable()), expressionTree))) {
            return;
        }
        ExpressionTree config = WeakSSLProtocolCheck.getAssignedValue(expressionTree);
        if (!WeakSSLProtocolCheck.isArrayInitializer(config)) {
            return;
        }
        WeakSSLProtocolCheck.getProperty((ArrayInitializerTree)config, "SSL").flatMap(sslConfig -> {
            if (WeakSSLProtocolCheck.isArrayInitializer(sslConfig)) {
                return WeakSSLProtocolCheck.getProperty((ArrayInitializerTree)sslConfig, CRYPTO_METHOD_KEY);
            }
            return Optional.empty();
        }).ifPresent(value -> this.checkStreamWeakProtocol((ExpressionTree)value, STREAM_CONTEXT_CREATE));
    }

    private boolean checkOptionsReassignment(ReadWriteUsages usages, ExpressionTree expressionTree) {
        Symbol symbol = this.context().symbolTable().getSymbol(expressionTree);
        if (symbol == null) {
            return false;
        }
        List<Tree> optionsSslAccesses = usages.getWritesSorted(symbol).stream().map(Tree::getParent).filter(tree -> WeakSSLProtocolCheck.isArrayObjectWithOffset(tree, "ssl")).map(Tree::getParent).toList();
        if (this.hasOptionsSslSensitiveAssignment(optionsSslAccesses)) {
            return true;
        }
        return optionsSslAccesses.stream().filter(tree -> WeakSSLProtocolCheck.isArrayObjectWithOffset(tree, CRYPTO_METHOD_KEY)).map(Tree::getParent).map(WeakSSLProtocolCheck::getAssignedValueFromParent).filter(Objects::nonNull).findFirst().map(tree -> this.checkStreamWeakProtocol((ExpressionTree)tree, STREAM_CONTEXT_CREATE)).orElse(false);
    }

    private static boolean isArrayInitializer(ExpressionTree param) {
        return param.is(Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.ARRAY_INITIALIZER_FUNCTION);
    }

    private boolean hasOptionsSslSensitiveAssignment(List<Tree> optionsSslAccesses) {
        return optionsSslAccesses.stream().map(WeakSSLProtocolCheck::getAssignedValueFromParent).filter(param -> param != null && WeakSSLProtocolCheck.isArrayInitializer(param)).findFirst().flatMap(c -> WeakSSLProtocolCheck.getProperty((ArrayInitializerTree)c, CRYPTO_METHOD_KEY)).map(tree -> this.checkStreamWeakProtocol((ExpressionTree)tree, STREAM_CONTEXT_CREATE)).orElse(false);
    }

    private boolean checkStreamWeakProtocol(ExpressionTree expressionTree, String functionName) {
        Stream<ExpressionTree> protocols = expressionTree.is(Tree.Kind.BITWISE_OR) ? WeakSSLProtocolCheck.getOperands((BinaryExpressionTree)expressionTree) : Stream.of(expressionTree);
        List<String> weakProtocols = STREAM_WEAK_PROTOCOLS.get(functionName);
        if (weakProtocols != null) {
            return protocols.map(protocol -> {
                NamespaceNameTree cryptoMethod;
                if (protocol.is(Tree.Kind.NAMESPACE_NAME) && weakProtocols.contains((cryptoMethod = (NamespaceNameTree)protocol).name().text())) {
                    this.context().newIssue(this, cryptoMethod, MESSAGE);
                    return true;
                }
                return false;
            }).reduce(false, Boolean::logicalOr);
        }
        return false;
    }

    private void checkCURLWeakProtocol(ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.NAMESPACE_NAME)) {
            NamespaceNameTree protocol = (NamespaceNameTree)expressionTree;
            CURL_WEAK_PROTOCOLS.forEach(weakProtocol -> {
                if (weakProtocol.equals(protocol.name().text())) {
                    this.context().newIssue(this, protocol, MESSAGE);
                }
            });
        }
    }

    private static Stream<ExpressionTree> getOperands(BinaryExpressionTree binaryExpressionTree) {
        if (binaryExpressionTree.leftOperand().is(Tree.Kind.BITWISE_OR)) {
            return Stream.concat(Stream.of(binaryExpressionTree.rightOperand()), WeakSSLProtocolCheck.getOperands((BinaryExpressionTree)binaryExpressionTree.leftOperand()));
        }
        return Stream.of(binaryExpressionTree.leftOperand(), binaryExpressionTree.rightOperand());
    }

    private static Optional<ExpressionTree> getProperty(ArrayInitializerTree params, String property) {
        return params.arrayPairs().stream().filter(pair -> CheckUtils.isStringLiteralWithValue(pair.key(), property)).map(pair -> WeakSSLProtocolCheck.getAssignedValue(pair.value())).findFirst();
    }

    private static ExpressionTree getAssignedValue(ExpressionTree value) {
        if (value.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            return CheckUtils.uniqueAssignedValue((VariableIdentifierTree)value).orElse(value);
        }
        return value;
    }

    @Nullable
    private static ExpressionTree getAssignedValueFromParent(@Nullable Tree tree) {
        return Optional.ofNullable(tree).map(Tree::getParent).filter(parent -> parent != null && parent.is(Tree.Kind.ASSIGNMENT)).map(parent -> ((AssignmentExpressionTree)parent).value()).orElse(null);
    }

    private static boolean isArrayObjectWithOffset(@Nullable Tree tree, String offset) {
        ArrayAccessTree arrayAccessTree;
        if (tree == null) {
            return false;
        }
        Tree tree2 = tree.getParent();
        return tree2 instanceof ArrayAccessTree && CheckUtils.isStringLiteralWithValue((arrayAccessTree = (ArrayAccessTree)tree2).offset(), offset);
    }
}

