/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.php.utils.collections.MapBuilder;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;

@Rule(key="S5785")
public class AssertTrueInsteadOfDedicatedAssertCheck
extends PhpUnitCheck {
    private static final String MESSAGE_USE_INSTEAD = "Use %s() instead.";
    private static final String SECONDARY_MESSAGE_USE_INSTEAD = "%s is performed here, which is better expressed with %s.";
    private static final String MESSAGE_SIMPLIFY = "Simplify this expression by %sremoving the comparison to '%s'.";
    private static final String ASSERT_TRUE = "assertTrue";
    private static final String ASSERT_FALSE = "assertFalse";
    private static final Set<String> ASSERT_BOOLEAN_METHOD_NAMES = Set.of("assertTrue", "assertFalse");
    private static final Map<ReplacementAssertion, ReplacementAssertion> COMPLEMENTS = MapBuilder.builder().put(ReplacementAssertion.NULL, ReplacementAssertion.NOT_NULL).put(ReplacementAssertion.NOT_NULL, ReplacementAssertion.NULL).put(ReplacementAssertion.SAME, ReplacementAssertion.NOT_SAME).put(ReplacementAssertion.NOT_SAME, ReplacementAssertion.SAME).put(ReplacementAssertion.EQUALS, ReplacementAssertion.NOT_EQUALS).put(ReplacementAssertion.NOT_EQUALS, ReplacementAssertion.EQUALS).build();
    private static final Map<String, String> ASSERTIONS_COMPLEMENT = Map.of("assertFalse", "assertTrue", "assertTrue", "assertFalse");

    @Override
    public void visitFunctionCall(FunctionCallTree fct) {
        if (!this.isPhpUnitTestMethod()) {
            return;
        }
        AssertTrueInsteadOfDedicatedAssertCheck.getAssertion(fct).ifPresent(a -> {
            if (ASSERT_BOOLEAN_METHOD_NAMES.contains(a.name())) {
                this.checkBooleanExpressionInAssertMethod(fct, a.name());
            }
        });
        super.visitFunctionCall(fct);
    }

    private void checkBooleanExpressionInAssertMethod(FunctionCallTree problematicAssertionCall, String assertionName) {
        CheckUtils.argumentValue(problematicAssertionCall, "", 0).ifPresent(argumentExpression -> {
            Optional<String> argumentValue = AssertTrueInsteadOfDedicatedAssertCheck.retrieveBooleanLiteralFromBinaryExpression(argumentExpression);
            if (argumentValue.isPresent()) {
                BinaryExpressionTree bet = (BinaryExpressionTree)argumentExpression;
                String booleanLiteralToRemove = argumentValue.get();
                String additionalAction = AssertTrueInsteadOfDedicatedAssertCheck.shouldChangeAssertionFunction(assertionName, booleanLiteralToRemove, bet) ? String.format("using %s() and ", ASSERTIONS_COMPLEMENT.get(assertionName)) : "";
                String message = String.format(MESSAGE_SIMPLIFY, additionalAction, booleanLiteralToRemove.toLowerCase(Locale.ROOT));
                this.newIssue(problematicAssertionCall, message);
            } else {
                Optional<ReplacementAssertion> replacementAssertionOpt = AssertTrueInsteadOfDedicatedAssertCheck.getReplacementAssertion(argumentExpression);
                if (assertionName.equals(ASSERT_FALSE)) {
                    replacementAssertionOpt = replacementAssertionOpt.map(COMPLEMENTS::get);
                }
                replacementAssertionOpt.ifPresent(replacementAssertion -> this.reportIssue(problematicAssertionCall, (ReplacementAssertion)((Object)((Object)replacementAssertion)), (ExpressionTree)argumentExpression));
            }
        });
    }

    private static boolean shouldChangeAssertionFunction(String assertionName, String booleanLiteralValue, BinaryExpressionTree bet) {
        boolean isAssertTrue = ASSERT_TRUE.equals(assertionName);
        boolean isTrueValue = "true".equalsIgnoreCase(booleanLiteralValue);
        boolean isEqualComparison = bet.is(Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO);
        return !(isAssertTrue && isTrueValue == isEqualComparison || !isAssertTrue && isTrueValue);
    }

    private void reportIssue(FunctionCallTree problematicAssertionCall, ReplacementAssertion replacementAssertion, ExpressionTree argumentExpression) {
        this.newIssue(problematicAssertionCall, replacementAssertion.useInsteadMessage).secondary(argumentExpression, replacementAssertion.secondaryExplanationMessage);
    }

    private static Optional<ReplacementAssertion> getReplacementAssertion(ExpressionTree argumentExpression) {
        ReplacementAssertion replacementAssertion = null;
        argumentExpression = CheckUtils.skipParenthesis(argumentExpression);
        switch (argumentExpression.getKind()) {
            case EQUAL_TO: {
                if (AssertTrueInsteadOfDedicatedAssertCheck.isCheckForNull((BinaryExpressionTree)argumentExpression)) {
                    replacementAssertion = ReplacementAssertion.NULL;
                    break;
                }
                replacementAssertion = ReplacementAssertion.EQUALS;
                break;
            }
            case STRICT_EQUAL_TO: {
                if (AssertTrueInsteadOfDedicatedAssertCheck.isCheckForNull((BinaryExpressionTree)argumentExpression)) {
                    replacementAssertion = ReplacementAssertion.NULL;
                    break;
                }
                replacementAssertion = ReplacementAssertion.SAME;
                break;
            }
            case NOT_EQUAL_TO: {
                if (AssertTrueInsteadOfDedicatedAssertCheck.isCheckForNull((BinaryExpressionTree)argumentExpression)) {
                    replacementAssertion = ReplacementAssertion.NOT_NULL;
                    break;
                }
                replacementAssertion = ReplacementAssertion.NOT_EQUALS;
                break;
            }
            case STRICT_NOT_EQUAL_TO: {
                if (AssertTrueInsteadOfDedicatedAssertCheck.isCheckForNull((BinaryExpressionTree)argumentExpression)) {
                    replacementAssertion = ReplacementAssertion.NOT_NULL;
                    break;
                }
                replacementAssertion = ReplacementAssertion.NOT_SAME;
                break;
            }
            case LOGICAL_COMPLEMENT: {
                return AssertTrueInsteadOfDedicatedAssertCheck.getReplacementAssertion(((UnaryExpressionTree)argumentExpression).expression()).map(COMPLEMENTS::get);
            }
        }
        return Optional.ofNullable(replacementAssertion);
    }

    private static boolean isCheckForNull(BinaryExpressionTree bet) {
        return bet.leftOperand().is(Tree.Kind.NULL_LITERAL) || bet.rightOperand().is(Tree.Kind.NULL_LITERAL);
    }

    private static Optional<String> retrieveBooleanLiteralFromBinaryExpression(ExpressionTree expr) {
        if (expr.is(Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO)) {
            BinaryExpressionTree bet = (BinaryExpressionTree)expr;
            if (bet.leftOperand().is(Tree.Kind.BOOLEAN_LITERAL)) {
                return Optional.of(((LiteralTree)bet.leftOperand()).value());
            }
            if (bet.rightOperand().is(Tree.Kind.BOOLEAN_LITERAL)) {
                return Optional.of(((LiteralTree)bet.rightOperand()).value());
            }
        }
        return Optional.empty();
    }

    private static enum ReplacementAssertion {
        NULL("Null", "A null-check"),
        NOT_NULL("NotNull", "A null-check"),
        SAME("Same", "A type-safe equality check"),
        NOT_SAME("NotSame", "A type-safe equality check"),
        EQUALS("Equals", "An equality check"),
        NOT_EQUALS("NotEquals", "An equality check");

        public final String methodName;
        public final String actionDescription;
        public final String useInsteadMessage;
        public final String secondaryExplanationMessage;

        private ReplacementAssertion(String namePostfix, String actionDescription) {
            this.methodName = "assert" + namePostfix;
            this.actionDescription = actionDescription;
            this.useInsteadMessage = String.format(AssertTrueInsteadOfDedicatedAssertCheck.MESSAGE_USE_INSTEAD, this.methodName);
            this.secondaryExplanationMessage = String.format(AssertTrueInsteadOfDedicatedAssertCheck.SECONDARY_MESSAGE_USE_INSTEAD, actionDescription, this.methodName);
        }
    }
}

