/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.php.symbols.MethodSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.php.tree.TreeUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S5899")
public class NotDiscoverableTestCheck
extends PhpUnitCheck {
    private static final String MESSAGE_VISIBLE = "Adjust the visibility of this test method so that it can be executed by the test runner.";
    private static final String MESSAGE_MARKED = "Mark this method as a test so that it can be executed by the test runner.";
    private static final Set<String> OVERRIDABLE_METHODS = Set.of("setup", "teardown", "setupbeforeclass", "teardownafterclass");
    private static final Set<String> SELF_OBJECTS = Set.of("$this", "self", "static");
    private Map<String, Set<String>> internalCalledMethods = new HashMap<String, Set<String>>();
    private Set<String> testMethods = new HashSet<String>();

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        if (tree.isAbstract() || CheckUtils.getClassName(tree).endsWith("TestCase")) {
            return;
        }
        super.visitClassDeclaration(tree);
    }

    @Override
    protected void visitPhpUnitTestCase(ClassDeclarationTree tree) {
        InternalCallsFindVisitor callsFindVisitor = new InternalCallsFindVisitor();
        tree.accept(callsFindVisitor);
        this.internalCalledMethods = callsFindVisitor.calledFunctions;
        this.testMethods = callsFindVisitor.testMethods;
        super.visitPhpUnitTestCase(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (!this.isPhpUnitTestCase()) {
            return;
        }
        if (!CheckUtils.isPublic(tree) && NotDiscoverableTestCheck.isMarkedAsTestMethod(tree)) {
            this.newIssue(tree.name(), MESSAGE_VISIBLE);
        } else if (!(!CheckUtils.isPublic(tree) || NotDiscoverableTestCheck.isMarkedAsTestMethod(tree) || this.isCalledMethod(tree) || !NotDiscoverableTestCheck.methodContainsAssertions(tree) || CheckUtils.isStatic(tree) && NotDiscoverableTestCheck.isMethodWithReturn(tree))) {
            this.newIssue(tree.name(), MESSAGE_MARKED);
        }
    }

    private boolean isCalledMethod(MethodDeclarationTree tree) {
        String methodName = tree.name().text().toLowerCase(Locale.ROOT);
        return this.testMethods.stream().anyMatch(t -> this.callPathExists((String)t, methodName));
    }

    private static boolean isMethodWithReturn(MethodDeclarationTree tree) {
        MethodSymbol methodSymbol = Symbols.get(tree);
        return methodSymbol.hasReturn();
    }

    private boolean callPathExists(String start, String end) {
        HashSet<String> visited = new HashSet<String>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        stack.push(start);
        while (!stack.isEmpty()) {
            String currentEl = (String)stack.pop();
            if (currentEl.equals(end)) {
                return true;
            }
            if (visited.contains(currentEl) || !this.internalCalledMethods.containsKey(currentEl)) continue;
            visited.add(currentEl);
            this.internalCalledMethods.get(currentEl).forEach(stack::push);
        }
        return false;
    }

    private static boolean methodContainsAssertions(MethodDeclarationTree tree) {
        AssertionsFindVisitor assertionsFindVisitor = new AssertionsFindVisitor();
        tree.accept(assertionsFindVisitor);
        return assertionsFindVisitor.hasFoundAssertion;
    }

    private static boolean isMarkedAsTestMethod(MethodDeclarationTree tree) {
        return tree.name().text().startsWith("test") || TreeUtils.hasAnnotation(tree, "test");
    }

    private static class InternalCallsFindVisitor
    extends PhpUnitCheck {
        private final Map<String, Set<String>> calledFunctions = new HashMap<String, Set<String>>();
        private final Set<String> testMethods = new HashSet<String>();
        private String currentMethodName;

        private InternalCallsFindVisitor() {
        }

        @Override
        public void visitMethodDeclaration(MethodDeclarationTree tree) {
            this.currentMethodName = tree.name().text().toLowerCase(Locale.ROOT);
            if (OVERRIDABLE_METHODS.contains(this.currentMethodName)) {
                this.testMethods.add(this.currentMethodName);
            }
            super.visitMethodDeclaration(tree);
        }

        @Override
        protected void visitPhpUnitTestMethod(MethodDeclarationTree tree) {
            this.testMethods.add(this.currentMethodName);
        }

        @Override
        public void visitFunctionCall(FunctionCallTree tree) {
            String functionName = CheckUtils.lowerCaseFunctionName(tree);
            if (functionName != null && InternalCallsFindVisitor.isInternalMethodCall(tree)) {
                this.calledFunctions.computeIfAbsent(this.currentMethodName, f -> new HashSet()).add(functionName);
            }
            super.visitFunctionCall(tree);
        }

        private static boolean isInternalMethodCall(FunctionCallTree tree) {
            if (!tree.callee().is(Tree.Kind.OBJECT_MEMBER_ACCESS, Tree.Kind.CLASS_MEMBER_ACCESS)) {
                return false;
            }
            String objectString = ((MemberAccessTree)tree.callee()).object().toString().toLowerCase(Locale.ROOT);
            return SELF_OBJECTS.contains(objectString);
        }
    }

    private static class AssertionsFindVisitor
    extends PHPVisitorCheck {
        private boolean hasFoundAssertion = false;

        private AssertionsFindVisitor() {
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
        }

        @Override
        public void visitFunctionCall(FunctionCallTree tree) {
            if (PhpUnitCheck.isAssertion(tree) && TreeUtils.findAncestorWithKind((Tree)tree, Collections.singletonList(Tree.Kind.NEW_EXPRESSION)) == null) {
                this.hasFoundAssertion = true;
            }
            super.visitFunctionCall(tree);
        }
    }
}

