/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.regex;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.regex.AbstractRegexCheck;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;

@Rule(key="S5361")
public class StringReplaceCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Replace this \"preg_replace()\" call by a \"str_replace()\" function call.";
    private static final int LIMIT_PARAM_INDEX = 3;
    private static final String LIMIT_PARAM_NAME = "limit";

    @Override
    protected Set<String> lookedUpFunctionNames() {
        return Collections.singleton("preg_replace");
    }

    @Override
    protected void checkFunctionCall(FunctionCallTree tree) {
        if (StringReplaceCheck.limitParameterIsNotUsedOrSetToDefault(tree)) {
            super.checkFunctionCall(tree);
        }
    }

    @Override
    public void checkRegex(RegexParseResult regexParseResult, FunctionCallTree regexFunctionCall) {
        RegexTree regex = regexParseResult.getResult();
        if (!regexParseResult.hasSyntaxErrors() && StringReplaceCheck.isPlainString(regex)) {
            this.newIssue(regexFunctionCall.callee(), MESSAGE, null, Collections.singletonList(new RegexIssueLocation(regex, "Expression without regular expression features.")));
        }
    }

    private static boolean limitParameterIsNotUsedOrSetToDefault(FunctionCallTree tree) {
        Optional<ExpressionTree> limitParamTree = CheckUtils.argumentValue(tree, LIMIT_PARAM_NAME, 3);
        return limitParamTree.isEmpty() || limitParamTree.get().is(Tree.Kind.UNARY_MINUS);
    }

    private static boolean isPlainString(RegexTree regex) {
        return regex.is(RegexTree.Kind.CHARACTER) || regex.is(RegexTree.Kind.SEQUENCE) && !((SequenceTree)regex).getItems().isEmpty() && ((SequenceTree)regex).getItems().stream().allMatch(item -> item.is(RegexTree.Kind.CHARACTER));
    }
}

