/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.DeclareStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

public class AbstractStatementsCheck
extends PHPSubscriptionCheck {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.SCRIPT, Tree.Kind.BLOCK, Tree.Kind.CASE_CLAUSE, Tree.Kind.DEFAULT_CLAUSE, Tree.Kind.DECLARE_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.ALTERNATIVE_IF_STATEMENT, Tree.Kind.ELSE_CLAUSE, Tree.Kind.ALTERNATIVE_ELSE_CLAUSE, Tree.Kind.ELSEIF_CLAUSE, Tree.Kind.ALTERNATIVE_ELSEIF_CLAUSE, Tree.Kind.FOREACH_STATEMENT, Tree.Kind.ALTERNATIVE_FOREACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.ALTERNATIVE_FOR_STATEMENT, Tree.Kind.NAMESPACE_STATEMENT, Tree.Kind.WHILE_STATEMENT);
    }

    public static List<StatementTree> getStatements(Tree tree) {
        return switch (tree.getKind()) {
            case Tree.Kind.SCRIPT -> ((ScriptTree)tree).statements();
            case Tree.Kind.BLOCK -> ((BlockTree)tree).statements();
            case Tree.Kind.CASE_CLAUSE, Tree.Kind.DEFAULT_CLAUSE -> ((SwitchCaseClauseTree)tree).statements();
            case Tree.Kind.DECLARE_STATEMENT -> ((DeclareStatementTree)tree).statements();
            case Tree.Kind.IF_STATEMENT, Tree.Kind.ALTERNATIVE_IF_STATEMENT -> ((IfStatementTree)tree).statements();
            case Tree.Kind.ELSE_CLAUSE, Tree.Kind.ALTERNATIVE_ELSE_CLAUSE -> ((ElseClauseTree)tree).statements();
            case Tree.Kind.ELSEIF_CLAUSE, Tree.Kind.ALTERNATIVE_ELSEIF_CLAUSE -> ((ElseifClauseTree)tree).statements();
            case Tree.Kind.FOREACH_STATEMENT, Tree.Kind.ALTERNATIVE_FOREACH_STATEMENT -> ((ForEachStatementTree)tree).statements();
            case Tree.Kind.FOR_STATEMENT, Tree.Kind.ALTERNATIVE_FOR_STATEMENT -> ((ForStatementTree)tree).statements();
            case Tree.Kind.NAMESPACE_STATEMENT -> ((NamespaceStatementTree)tree).statements();
            case Tree.Kind.WHILE_STATEMENT -> ((WhileStatementTree)tree).statements();
            default -> Collections.emptyList();
        };
    }
}

