/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public abstract class FunctionUsageCheck
extends PHPVisitorCheck {
    private Set<String> lowerCaseFunctionNames;

    protected abstract Set<String> lookedUpFunctionNames();

    @Override
    public void init() {
        super.init();
        this.lowerCaseFunctionNames = this.lookedUpFunctionNames().stream().map(name -> name.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    }

    protected abstract void checkFunctionCall(FunctionCallTree var1);

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (this.isExpectedFunction(tree.callee())) {
            this.checkFunctionCall(tree);
        }
        super.visitFunctionCall(tree);
    }

    private boolean isExpectedFunction(ExpressionTree callee) {
        return callee.is(Tree.Kind.NAMESPACE_NAME) && this.lowerCaseFunctionNames.contains(((NamespaceNameTree)callee).qualifiedName().toLowerCase(Locale.ROOT));
    }
}

