/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;

public class TreeValues {
    public final List<ExpressionTree> values;
    private final SymbolTable symbolTable;

    private TreeValues(List<ExpressionTree> values, SymbolTable symbolTable) {
        this.values = values;
        this.symbolTable = symbolTable;
    }

    public static TreeValues of(ExpressionTree node, SymbolTable symbolTable) {
        return new TreeValues(Collections.singletonList(node), symbolTable);
    }

    public TreeValues lookupPossibleValues(ExpressionTree tree) {
        Symbol symbol;
        ArrayList<ExpressionTree> result = new ArrayList<ExpressionTree>();
        ExpressionTree node = CheckUtils.skipParenthesis(tree);
        result.add(node);
        if (node.is(Tree.Kind.VARIABLE_IDENTIFIER) && (symbol = this.symbolTable.getSymbol(node)) != null) {
            Stream.concat(Stream.of(symbol.declaration()), symbol.usages().stream().map(Tree::getParent)).map(TreeValues::usageValue).filter(Objects::nonNull).forEach(result::add);
        }
        return new TreeValues(result, this.symbolTable);
    }

    @Nullable
    private static ExpressionTree usageValue(Tree tree) {
        ForEachStatementTree forEachStatement;
        Tree parent = tree.getParent();
        if (parent.is(Tree.Kind.ASSIGNMENT, Tree.Kind.ASSIGNMENT_BY_REFERENCE)) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)parent;
            if (assignment.variable() == tree) {
                return CheckUtils.skipParenthesis(assignment.value());
            }
        } else if (parent.is(Tree.Kind.FOREACH_STATEMENT) && (forEachStatement = (ForEachStatementTree)parent).value() == tree) {
            return forEachStatement.value();
        }
        return null;
    }
}

