/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.wordpress;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.wordpress.WordPressConfigVisitor;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S6341")
public class WordPressFileEditorCheck
extends WordPressConfigVisitor {
    private static final String MESSAGE = "Plugin and theme files editor is active";
    private FunctionCallTree fileEditConfigTree;
    private FunctionCallTree fileModsConfigTree;

    @Override
    public void visitScript(ScriptTree tree) {
        this.fileEditConfigTree = null;
        this.fileModsConfigTree = null;
        super.visitScript(tree);
        if (!this.fileModsDisallowed()) {
            if (this.fileEditConfigTree == null) {
                this.context().newFileIssue(this, MESSAGE);
            } else {
                WordPressFileEditorCheck.configValue(this.fileEditConfigTree).filter(CheckUtils::isFalseValue).ifPresent(value -> this.newIssue(this.fileEditConfigTree, MESSAGE));
            }
        }
        this.fileEditConfigTree = null;
        this.fileModsConfigTree = null;
    }

    @Override
    protected Set<String> configsToVisit() {
        return new HashSet<String>(Arrays.asList("DISALLOW_FILE_EDIT", "DISALLOW_FILE_MODS"));
    }

    @Override
    void visitConfigDeclaration(FunctionCallTree config) {
        if (WordPressFileEditorCheck.isConfigKey(config, "DISALLOW_FILE_EDIT")) {
            this.fileEditConfigTree = config;
        } else {
            this.fileModsConfigTree = config;
        }
    }

    private boolean fileModsDisallowed() {
        return this.fileModsConfigTree != null && !WordPressFileEditorCheck.configValue(this.fileModsConfigTree).filter(CheckUtils::isFalseValue).isPresent();
    }
}

