/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.visitors;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.regex.PhpRegexCheck;
import org.sonar.php.regex.RegexCache;
import org.sonar.php.regex.RegexCheckContext;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.plugins.php.api.cache.CacheContext;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.CheckContext;
import org.sonar.plugins.php.api.visitors.FileIssue;
import org.sonar.plugins.php.api.visitors.IssueLocation;
import org.sonar.plugins.php.api.visitors.LineIssue;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PhpFile;
import org.sonar.plugins.php.api.visitors.PhpInputFileContext;
import org.sonar.plugins.php.api.visitors.PhpIssue;
import org.sonar.plugins.php.api.visitors.PreciseIssue;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public class PHPCheckContext
implements CheckContext,
RegexCheckContext {
    private final PhpInputFileContext inputFileContext;
    private final CompilationUnitTree tree;
    private final SymbolTable symbolTable;
    private final List<PhpIssue> issues = new ArrayList<PhpIssue>();
    private final RegexCache regexCache = new RegexCache();

    public PHPCheckContext(PhpFile file, CompilationUnitTree tree, @Nullable File workingDirectory) {
        this(file, tree, workingDirectory, SymbolTableImpl.create(tree));
    }

    public PHPCheckContext(PhpFile file, CompilationUnitTree tree, @Nullable File workingDirectory, SymbolTable symbolTable) {
        this(new PhpInputFileContext(file, workingDirectory, null), tree, symbolTable);
    }

    public PHPCheckContext(PhpInputFileContext fileContext, CompilationUnitTree tree, SymbolTable symbolTable) {
        this.inputFileContext = fileContext;
        this.tree = tree;
        this.symbolTable = symbolTable;
    }

    @Override
    public CompilationUnitTree tree() {
        return this.tree;
    }

    @Override
    public PreciseIssue newIssue(PHPCheck check, Tree tree, String message) {
        return this.newIssue(check, new IssueLocation(tree, message));
    }

    @Override
    public PreciseIssue newIssue(PHPCheck check, Tree startTree, Tree endTree, String message) {
        return this.newIssue(check, new IssueLocation(startTree, endTree, message));
    }

    @Override
    public PreciseIssue newIssue(PhpRegexCheck check, RegexSyntaxElement regexTree, String message) {
        return this.newIssue(check, new PhpRegexCheck.PhpRegexIssueLocation(regexTree, message));
    }

    @Override
    public PreciseIssue newIssue(PHPCheck check, IssueLocation issueLocation) {
        PreciseIssue issue = new PreciseIssue(check, issueLocation);
        this.issues.add(issue);
        return issue;
    }

    @Override
    public RegexParseResult regexForLiteral(FlagSet initialFlags, LiteralTree stringLiteral) {
        return this.regexCache.getRegexForLiterals(initialFlags, stringLiteral);
    }

    @Override
    public LineIssue newLineIssue(PHPCheck check, int line, String message) {
        LineIssue issue = new LineIssue(check, line, message);
        this.issues.add(issue);
        return issue;
    }

    @Override
    public FileIssue newFileIssue(PHPCheck check, String message) {
        FileIssue issue = new FileIssue(check, message);
        this.issues.add(issue);
        return issue;
    }

    @Override
    public PhpFile getPhpFile() {
        return this.inputFileContext.phpFile();
    }

    @Override
    public List<PhpIssue> getIssues() {
        return Collections.unmodifiableList(this.issues);
    }

    @Override
    public SymbolTable symbolTable() {
        return this.symbolTable;
    }

    @Override
    public File getWorkingDirectory() {
        return this.inputFileContext.workingDirectory();
    }

    @Override
    public CacheContext cacheContext() {
        return this.inputFileContext.cacheContext();
    }
}

