/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.channel;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import org.sonar.sslr.channel.ChannelException;
import org.sonar.sslr.channel.CodeBuffer;
import org.sonar.sslr.channel.CodeReaderConfiguration;
import org.sonar.sslr.channel.EndMatcher;

public class CodeReader
extends CodeBuffer {
    private CodeBuffer.Cursor previousCursor;

    public CodeReader(Reader code) {
        super(code, new CodeReaderConfiguration());
    }

    public CodeReader(String code) {
        super(code, new CodeReaderConfiguration());
    }

    public CodeReader(Reader code, CodeReaderConfiguration configuration) {
        super(code, configuration);
    }

    public CodeReader(String code, CodeReaderConfiguration configuration) {
        super(code, configuration);
    }

    public final void pop(Appendable appendable) {
        try {
            appendable.append((char)this.pop());
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage(), e);
        }
    }

    public final char[] peek(int length) {
        char[] result = new char[length];
        int index = 0;
        int nextChar = this.intAt(index);
        while (nextChar != -1 && index < length) {
            result[index] = (char)nextChar;
            nextChar = this.intAt(++index);
        }
        return result;
    }

    public final void peekTo(EndMatcher matcher, Appendable appendable) {
        int index = 0;
        int nextChar = this.intAt(index);
        try {
            while (!matcher.match(nextChar) && nextChar != -1) {
                appendable.append((char)nextChar);
                nextChar = this.intAt(++index);
            }
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage(), e);
        }
    }

    public final int popTo(Matcher matcher, Appendable appendable) {
        return this.popTo(matcher, null, appendable);
    }

    public final int popTo(Matcher matcher, Matcher afterMatcher, Appendable appendable) {
        try {
            matcher.reset(this);
            if (matcher.lookingAt()) {
                int i;
                if (afterMatcher != null) {
                    afterMatcher.reset(this);
                    afterMatcher.region(matcher.end(), this.length());
                    if (!afterMatcher.lookingAt()) {
                        int n = -1;
                        return n;
                    }
                }
                this.previousCursor = this.getCursor().clone();
                for (i = 0; i < matcher.end(); ++i) {
                    appendable.append((char)this.pop());
                }
                i = matcher.end();
                return i;
            }
        }
        catch (StackOverflowError e) {
            throw new ChannelException("Unable to apply regular expression '" + matcher.pattern().pattern() + "' at line " + this.getCursor().getLine() + " and column " + this.getCursor().getColumn() + ", because it led to a stack overflow error. This error may be due to an inefficient use of alternations - see http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5050507", e);
        }
        catch (IndexOutOfBoundsException e) {
            int n = -1;
            return n;
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage(), e);
        }
        finally {
            matcher.reset("");
        }
        return -1;
    }

    public final CodeBuffer.Cursor getPreviousCursor() {
        return this.previousCursor;
    }
}

