/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import java.util.Arrays;
import org.sonar.sslr.internal.vm.CompilationHandler;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.ParsingExpression;

public class FirstOfExpression
implements ParsingExpression {
    private final ParsingExpression[] subExpressions;

    public FirstOfExpression(ParsingExpression ... subExpressions) {
        this.subExpressions = subExpressions;
    }

    @Override
    public Instruction[] compile(CompilationHandler compiler) {
        int index = 0;
        Instruction[][] sub = new Instruction[this.subExpressions.length][];
        for (int i = 0; i < this.subExpressions.length; ++i) {
            sub[i] = compiler.compile(this.subExpressions[i]);
            index += sub[i].length;
        }
        Instruction[] result = new Instruction[index + (this.subExpressions.length - 1) * 2];
        index = 0;
        for (int i = 0; i < this.subExpressions.length - 1; ++i) {
            result[index] = Instruction.choice(sub[i].length + 2);
            System.arraycopy(sub[i], 0, result, index + 1, sub[i].length);
            result[index += sub[i].length + 1] = Instruction.commit(result.length - index);
            ++index;
        }
        System.arraycopy(sub[sub.length - 1], 0, result, index, sub[sub.length - 1].length);
        return result;
    }

    public String toString() {
        return "FirstOf" + Arrays.toString(this.subExpressions);
    }
}

