/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm.lexerful;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.vm.Machine;
import org.sonar.sslr.internal.vm.NativeExpression;

public class TokensBridgeExpression
extends NativeExpression
implements Matcher {
    private final TokenType from;
    private final TokenType to;

    public TokensBridgeExpression(TokenType from, TokenType to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public void execute(Machine machine) {
        int length = machine.length();
        if (length < 2 || machine.tokenAt(0).getType() != this.from) {
            machine.backtrack();
            return;
        }
        int offset = 0;
        int bridgeLevel = 1;
        do {
            if (++offset >= length) {
                machine.backtrack();
                return;
            }
            Token token = machine.tokenAt(offset);
            if (token.getType() == this.from) {
                ++bridgeLevel;
                continue;
            }
            if (token.getType() != this.to) continue;
            --bridgeLevel;
        } while (bridgeLevel != 0);
        for (int i = 0; i <= offset; ++i) {
            machine.createLeafNode(this, 1);
        }
        machine.jump(1);
    }

    public String toString() {
        return "Bridge[" + this.from + "," + this.to + "]";
    }
}

