/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.auth;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bozaro.gitlfs.client.auth.AuthProvider;
import ru.bozaro.gitlfs.common.data.Link;
import ru.bozaro.gitlfs.common.data.Operation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/bozaro/gitlfs/client/auth/BasicAuthProvider;", "Lru/bozaro/gitlfs/client/auth/AuthProvider;", "href", "Ljava/net/URI;", "login", "", "password", "(Ljava/net/URI;Ljava/lang/String;Ljava/lang/String;)V", "auth", "Lru/bozaro/gitlfs/common/data/Link;", "getAuth", "operation", "Lru/bozaro/gitlfs/common/data/Operation;", "invalidateAuth", "", "Companion", "gitlfs-client"})
public final class BasicAuthProvider
implements AuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Link auth;

    public BasicAuthProvider(@NotNull URI href, @Nullable String login, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        String authLogin = BasicAuthProvider.Companion.isEmpty(login) ? BasicAuthProvider.Companion.extractLogin(href.getUserInfo()) : login;
        String authPassword = BasicAuthProvider.Companion.isEmpty(password) ? BasicAuthProvider.Companion.extractPassword(href.getUserInfo()) : password;
        TreeMap header = new TreeMap();
        String userInfo = authLogin + ":" + authPassword;
        Map map = header;
        String string = "Authorization";
        Object object = userInfo;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = Base64.encodeBase64((byte[])byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encodeBase64(userInfo.to\u2026(StandardCharsets.UTF_8))");
        Object object2 = byArray2;
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        object = charset2;
        object2 = "Basic " + new String((byte[])object2, (Charset)object);
        map.put(string, object2);
        try {
            String scheme = Intrinsics.areEqual((Object)"git", (Object)href.getScheme()) ? "https" : href.getScheme();
            this.auth = new Link(new URI(scheme, href.getAuthority(), href.getPath(), null, null), Collections.unmodifiableMap(header), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public /* synthetic */ BasicAuthProvider(URI uRI, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(uRI, string, string2);
    }

    @Override
    @NotNull
    public Link getAuth(@NotNull Operation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return this.auth;
    }

    @Override
    public void invalidateAuth(@NotNull Operation operation, @NotNull Link auth) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0006\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\n"}, d2={"Lru/bozaro/gitlfs/client/auth/BasicAuthProvider$Companion;", "", "()V", "extractLogin", "", "userInfo", "extractPassword", "isEmpty", "", "value", "gitlfs-client"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isEmpty(String value) {
            return value == null || ((CharSequence)value).length() == 0;
        }

        private final String extractLogin(String userInfo) {
            String string;
            if (userInfo == null) {
                return "";
            }
            int separator = StringsKt.indexOf$default((CharSequence)userInfo, (char)':', (int)0, (boolean)false, (int)6, null);
            if (separator >= 0) {
                String string2 = userInfo.substring(0, separator);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string = userInfo;
            }
            return string;
        }

        private final String extractPassword(String userInfo) {
            String string;
            if (userInfo == null) {
                return "";
            }
            int separator = StringsKt.indexOf$default((CharSequence)userInfo, (char)':', (int)0, (boolean)false, (int)6, null);
            if (separator >= 0) {
                String string2 = userInfo.substring(separator + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = "";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

