/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.sharded;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.sharded.IShardingStrategy;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.FunctionWithException;

public class PatternBasedShardingStrategy
implements IShardingStrategy {
    private final PairList<String, Pattern> nameAndPattern;
    private final File baseDirectory;
    private final FunctionWithException<String, List<String>, StorageException> storageSystemNamePreAdjuster;

    public PatternBasedShardingStrategy(PairList<String, Pattern> nameAndPattern, File baseDirectory, FunctionWithException<String, List<String>, StorageException> storageSystemNamePreAdjuster) {
        Preconditions.checkArgument((!nameAndPattern.isEmpty() ? 1 : 0) != 0, (Object)"Name/pattern list may not be empty!");
        this.nameAndPattern = nameAndPattern;
        this.baseDirectory = baseDirectory;
        this.storageSystemNamePreAdjuster = storageSystemNamePreAdjuster;
    }

    @Override
    public int getShardCount() {
        return this.nameAndPattern.size();
    }

    @Override
    public File getShardDirectory(int index) {
        String name = (String)this.nameAndPattern.getFirst(index);
        if (FileSystemUtils.isAbsolutePath((String)name)) {
            return new File(name);
        }
        return new File(this.baseDirectory, name);
    }

    @Override
    public int getShardIndexForStorageSystemName(String storageSystemName) throws StorageException {
        List matcherCandidates = (List)this.storageSystemNamePreAdjuster.apply((Object)storageSystemName);
        for (int i = 0; i < this.nameAndPattern.size(); ++i) {
            for (String candidate : matcherCandidates) {
                if (!((Pattern)this.nameAndPattern.getSecond(i)).matcher(candidate).matches()) continue;
                return i;
            }
        }
        return this.nameAndPattern.size() - 1;
    }

    public static PatternBasedShardingStrategy parse(String description, File baseDirectory, FunctionWithException<String, List<String>, StorageException> storageSystemNamePreAdjuster) throws StorageException {
        String[] parts = description.split(":");
        if (parts.length % 2 == 1) {
            throw new StorageException("Parsing description yielded " + parts.length + " parts, but an even number is required!");
        }
        PairList nameAndPattern = new PairList();
        for (int i = 0; i < parts.length; i += 2) {
            nameAndPattern.add((Object)parts[i], (Object)Pattern.compile(parts[i + 1]));
        }
        return new PatternBasedShardingStrategy((PairList<String, Pattern>)nameAndPattern, baseDirectory, storageSystemNamePreAdjuster);
    }
}

