/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jspecify.annotations.NonNull;

public final class StorageAbbreviation
implements Comparable<StorageAbbreviation> {
    public static final int LENGTH = 4;
    private final int value;

    private StorageAbbreviation(int value) {
        this.value = value;
    }

    static StorageAbbreviation of(int value) {
        return new StorageAbbreviation(value);
    }

    public static StorageAbbreviation of(byte[] value) {
        Objects.requireNonNull(value, "value");
        if (value.length != 4) {
            throw new IllegalArgumentException("The provided value must have a length of %d, but was %d".formatted(4, value.length));
        }
        return new StorageAbbreviation(ByteArrayUtils.byteArrayToInt((byte[])value));
    }

    public static StorageAbbreviation readFromStart(byte[] value) {
        return StorageAbbreviation.readFrom(value, 0);
    }

    public static StorageAbbreviation readFrom(byte[] value, int offset) {
        Objects.requireNonNull(value, "value");
        if (value.length - offset < 4) {
            throw new IllegalArgumentException("The provided value must have a length of %d to read from offset %d, but was %d".formatted(offset + 4, offset, value.length));
        }
        return new StorageAbbreviation(ByteArrayUtils.getIntFromByteArray((byte[])value, (int)offset));
    }

    public static StorageAbbreviation readFrom(DataInput input) throws IOException {
        Objects.requireNonNull(input, "input");
        return StorageAbbreviation.of(input.readInt());
    }

    int getId() {
        return this.value;
    }

    public byte[] toByteArray() {
        return ByteArrayUtils.intToByteArray((int)this.value);
    }

    public void writeTo(DataOutput output) throws IOException {
        output.writeInt(this.value);
    }

    public int writeTo(byte[] data, int offset) {
        ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)offset, (int)this.value);
        return 4;
    }

    @Override
    public int compareTo(@NonNull StorageAbbreviation o) {
        return Integer.compare(this.value, o.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof StorageAbbreviation)) return false;
        StorageAbbreviation that = (StorageAbbreviation)o;
        if (this.value != that.value) return false;
        return true;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return "StorageAbbreviation{value=%d}".formatted(this.value);
    }

    public static ISerializer<StorageAbbreviation, byte[]> serializer() {
        return ISerializer.of(StorageAbbreviation::toByteArray, StorageAbbreviation::of);
    }
}

