/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.index.admin.instance_comparison.option.IInstanceComparisonAcceptableDeviationsOption;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="instance-comparison-log-error", name="Log Errors", type=EOptionType.SERVER, category=EOptionCategory.INSTANCE_COMPARISON, orderingHint=650)
@IndexValueClass(containedInBackup=true)
public class InstanceComparisonLogErrorOption
implements IInstanceComparisonAcceptableDeviationsOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "instance-comparison-log-error";
    @JsonProperty(value="workerLogs")
    @OptionFieldDescription(name="Accepted Deviation for project worker logs", description="How large the deviation of the number of work logs of a single trigger may be compared to the remote number of logs. The specification is in decimal numbers.")
    public double workerLogs = 0.01;
    @JsonProperty(value="parseLogs")
    @OptionFieldDescription(name="Accepted Deviation for parse logs", description="How large the deviation of the number of parse logs of a single file may be compared to the remote number of logs. The specification is in decimal numbers.")
    public double parseLogs = 0.01;

    @Override
    public InstanceComparisonContributionBase.AcceptedComparisonDeviations getAcceptedComparisonDeviations() {
        return new InstanceComparisonContributionBase.AcceptedComparisonDeviations(0.0, this.getAcceptableDeviations(), (PairList<Pattern, Double>)PairList.emptyPairList());
    }

    private Map<String, Double> getAcceptableDeviations() {
        HashMap<String, Double> acceptableDeviations = new HashMap<String, Double>();
        acceptableDeviations.put("Parse Log Errors", this.parseLogs);
        acceptableDeviations.put("Worker Log Errors", this.workerLogs);
        return acceptableDeviations;
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        String validationResult = this.getAcceptableDeviations().entrySet().stream().filter(entry -> (Double)entry.getValue() < 0.0).map(entry -> String.format("Acceptable deviation of %s must be greater than or equal 0.", entry.getKey())).collect(Collectors.joining("\n"));
        return StringUtils.isEmpty((String)validationResult) ? null : validationResult;
    }
}

