/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.StringInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.SpecItemComparisonContributor;
import com.teamscale.index.admin.instance_comparison.util.MetricValueUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class SpecItemComparisonContribution
extends ProjectComparisonContributionBase {
    private static final long serialVersionUID = 1L;
    private static final String SPEC_ITEM_KNOWN_COLUMNS_PROPERTY = "knownColumns";
    private static final String SPEC_ITEM_CONTENT_HASH_PROPERTY = "contentHashByFilePath";
    private static final String SPEC_ITEM_METRICS_PROPERTY = "metricDirectoryEntries";
    @JsonProperty(value="knownColumns")
    private final String knownColumns;
    @JsonProperty(value="contentHashByFilePath")
    private final List<SpecItemComparisonContributor.HashEntry> specItemContentHash;
    @JsonProperty(value="metricDirectoryEntries")
    private final Map<String, Object> specItemMetrics;

    @JsonCreator
    SpecItemComparisonContribution(@JsonProperty(value="contributor") String contributor, @JsonProperty(value="project") String project, @JsonProperty(value="knownColumns") String knownColumns, @JsonProperty(value="contentHashByFilePath") List<SpecItemComparisonContributor.HashEntry> specItemContentHash, @JsonProperty(value="metricDirectoryEntries") Map<String, Object> specItemMetrics) {
        super(contributor, project);
        this.knownColumns = knownColumns;
        this.specItemContentHash = specItemContentHash;
        this.specItemMetrics = specItemMetrics;
    }

    public Map<String, IInstanceComparisonValue> getValues(InstanceComparisonContributionBase.ComparisonContext context) {
        HashMap<String, IInstanceComparisonValue> result = new HashMap<String, IInstanceComparisonValue>();
        this.addKnownColumns(result);
        this.addHashValues(result);
        this.addMetrics(result);
        return result;
    }

    private void addKnownColumns(Map<String, IInstanceComparisonValue> result) {
        String knownFieldsAndTypes = "Known field names and types";
        result.put(knownFieldsAndTypes, new StringInstanceComparisonValue(knownFieldsAndTypes, this.knownColumns));
    }

    private void addMetrics(Map<String, IInstanceComparisonValue> result) {
        for (Map.Entry<String, Object> entry : this.specItemMetrics.entrySet()) {
            result.put(entry.getKey(), MetricValueUtils.getComparisonValueForMetric(entry.getKey(), entry.getValue()));
        }
    }

    private void addHashValues(Map<String, IInstanceComparisonValue> result) {
        if (this.specItemContentHash.isEmpty()) {
            return;
        }
        for (SpecItemComparisonContributor.HashEntry hashEntry : this.specItemContentHash) {
            String primaryFieldsKey = "Primary fields hash of " + String.valueOf(hashEntry.specItemId());
            result.put(primaryFieldsKey, new StringInstanceComparisonValue(primaryFieldsKey, hashEntry.firstClassFieldHash()));
            String additionalFieldsKey = "Additional fields hash of " + String.valueOf(hashEntry.specItemId());
            result.put(additionalFieldsKey, new StringInstanceComparisonValue(additionalFieldsKey, hashEntry.additionalFieldsHash()));
        }
    }
}

