/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.assessment;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.architecture.assessment.ComponentOverlapping;
import com.teamscale.index.architecture.assessment.QuickCheckPattern;
import com.teamscale.index.architecture.assessment.shared.CodeMapping;
import com.teamscale.index.architecture.format.ECodeMappingType;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.jspecify.annotations.NonNull;

public class TypeToComponentMapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ArchitectureDefinition architecture;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final ListMap<ComponentNode, QuickCheckPattern> quickCheckIncludePatternsByComponent = new ListMap();
    private final ConcurrentMap<String, Pattern> compiledPatterns = new ConcurrentHashMap<String, Pattern>();
    private MappingResult current;

    public TypeToComponentMapper(ArchitectureDefinition architecture, IParallelTaskExecutor parallelTaskExecutor) {
        this.architecture = architecture;
        this.parallelTaskExecutor = parallelTaskExecutor;
    }

    public synchronized MappingResult map(Collection<String> types) {
        Set<String> set;
        this.current = MappingResult.empty();
        if (types instanceof Set) {
            Set s = (Set)types;
            set = s;
        } else {
            set = new HashSet<String>(types);
        }
        this.mapTypes(set);
        if (!this.architecture.isStructureOnly()) {
            this.checkForRedundantIncludePatterns();
        }
        this.setNumberOfMatches();
        MappingResult result = this.current;
        this.current = null;
        return result;
    }

    private void setNumberOfMatches() {
        Set<ComponentNode> components = this.architecture.getAllComponents();
        for (ComponentNode component : components) {
            this.setNumberOfMatchesForComponent(component);
        }
    }

    private void setNumberOfMatchesForComponent(ComponentNode component) {
        for (CodeMapping mapping : component.getCodeMappings()) {
            this.current.numberOfMatches.add((Object)component.getName(), (Object)this.getNumberOfMatches(mapping));
        }
    }

    private int getNumberOfMatches(CodeMapping mapping) {
        return switch (mapping.getType()) {
            default -> throw new MatchException(null, null);
            case ECodeMappingType.INCLUDE -> ((Set)this.current.includePatternsToTypes.getCollectionOrEmpty((Object)mapping.getPattern())).size();
            case ECodeMappingType.EXCLUDE -> ((Set)this.current.excludePatternsToTypes.getCollectionOrEmpty((Object)mapping.getPattern())).size();
            case ECodeMappingType.EXCLUDE_COMPONENT -> this.current.componentsToTypes.entrySet().stream().filter(entry -> ((ComponentNode)entry.getKey()).getName().equals(mapping.getPattern())).map(Map.Entry::getValue).findAny().orElse(Collections.emptySet()).size();
        };
    }

    private void checkForRedundantIncludePatterns() {
        for (ComponentNode component : this.current.componentsToTypes.getKeys()) {
            this.checkForRedundantIncludePatterns(component);
        }
    }

    private void checkForRedundantIncludePatterns(ComponentNode component) {
        PatternList includePatterns = component.getIncludePatterns();
        if (includePatterns.size() == 1) {
            return;
        }
        HashSet allTypes = new HashSet();
        for (Pattern includePattern : includePatterns) {
            allTypes.addAll(this.current.includePatternsToTypes.getCollectionOrEmpty((Object)includePattern.pattern()));
        }
        for (int i = 0; i < includePatterns.size(); ++i) {
            HashSet types = new HashSet();
            for (int j = 0; j < includePatterns.size(); ++j) {
                if (i == j) continue;
                types.addAll(this.current.includePatternsToTypes.getCollectionOrEmpty((Object)((Pattern)includePatterns.get(j)).pattern()));
            }
            if (allTypes.size() != types.size()) continue;
            this.current.redundantIncludePatterns.add((Object)component.getName(), (Object)((Pattern)includePatterns.get(i)).pattern());
        }
    }

    private void mapTypes(Set<String> types) {
        ListMap hashToIncludeLink = new ListMap();
        ListMap hashToExcludeLink = new ListMap();
        this.processComponents(this.architecture.getAllComponents(), (ListMap<Long, QuickCheckPattern>)hashToIncludeLink, (ListMap<Long, QuickCheckPattern>)hashToExcludeLink);
        try {
            this.parallelTaskExecutor.processInParallelBatches(new ArrayList<String>(types), typeBatch -> this.processTypes((Collection<String>)typeBatch, (ListMap<Long, QuickCheckPattern>)hashToIncludeLink, (ListMap<Long, QuickCheckPattern>)hashToExcludeLink));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void processTypes(Collection<String> types, ListMap<Long, QuickCheckPattern> hashToIncludeLink, ListMap<Long, QuickCheckPattern> hashToExcludeLink) {
        for (String type : types) {
            if (!this.architecture.isIncludedInScope(type)) continue;
            this.computeMatchingExcludePatternsForType(type, hashToExcludeLink);
            this.computeComponentToTypeMapping(hashToIncludeLink, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeComponentToTypeMapping(ListMap<Long, QuickCheckPattern> hashToIncludeLink, String type) {
        List<ComponentNode> matchingComponents = this.getMatchingComponents(type, hashToIncludeLink);
        if (matchingComponents.isEmpty()) {
            Set<String> set = this.current.unmatchedTypes;
            synchronized (set) {
                this.current.unmatchedTypes.add(type);
            }
        }
        SetMap<String, ComponentNode> setMap = this.current.typesToComponents;
        synchronized (setMap) {
            this.addComponentsToTypes(type, matchingComponents);
        }
    }

    private void addComponentsToTypes(String type, List<ComponentNode> matchingComponents) {
        for (ComponentNode node : matchingComponents) {
            this.current.typesToComponents.add((Object)type, (Object)node);
            this.current.componentsToTypes.add((Object)node, (Object)type);
        }
    }

    private void processComponents(Collection<ComponentNode> components, ListMap<Long, QuickCheckPattern> hashToIncludeLink, ListMap<Long, QuickCheckPattern> hashToExcludeLink) {
        for (ComponentNode component : components) {
            for (CodeMapping pattern : component.getCodeMappings()) {
                QuickCheckPattern quickCheckPattern = new QuickCheckPattern(pattern.getPattern(), component);
                if (pattern.getType() == ECodeMappingType.INCLUDE) {
                    this.quickCheckIncludePatternsByComponent.add((Object)component, (Object)quickCheckPattern);
                    hashToIncludeLink.add((Object)quickCheckPattern.calculateHash(), (Object)quickCheckPattern);
                    continue;
                }
                if (pattern.getType() != ECodeMappingType.EXCLUDE) continue;
                hashToExcludeLink.add((Object)quickCheckPattern.calculateHash(), (Object)quickCheckPattern);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeMatchingExcludePatternsForType(String type, ListMap<Long, QuickCheckPattern> hashToExcludeLink) {
        List<String> matchingPatterns = QuickCheckPattern.determinePrefixHashes(type).stream().map(arg_0 -> hashToExcludeLink.getCollectionOrEmpty(arg_0)).flatMap(Collection::stream).filter(pattern -> this.matches(type, (QuickCheckPattern)pattern)).map(QuickCheckPattern::getPattern).toList();
        SetMap<String, String> setMap = this.current.excludePatternsToTypes;
        synchronized (setMap) {
            for (String matchingPattern : matchingPatterns) {
                this.current.excludePatternsToTypes.add((Object)matchingPattern, (Object)type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ComponentNode> getMatchingComponents(String type, ListMap<Long, QuickCheckPattern> hashToIncludeLink) {
        IdentityHashSet<ComponentNode> componentCandidates = this.getComponentsIncludingType(type, hashToIncludeLink);
        ArrayList<ComponentNode> matchingComponents = new ArrayList<ComponentNode>();
        for (ComponentNode component : CollectionUtils.sort(componentCandidates, ComponentNode.BY_DEPTH_DESCENDING)) {
            if (this.isExplicitlyExcluded(type, component, componentCandidates, (IdentityHashSet<ComponentNode>)new IdentityHashSet())) continue;
            matchingComponents.add(component);
        }
        if (matchingComponents.isEmpty()) {
            return new ArrayList<ComponentNode>();
        }
        if (this.architecture.isStructureOnly()) {
            return matchingComponents;
        }
        ComponentNode matchingComponent = (ComponentNode)matchingComponents.getFirst();
        if (matchingComponents.size() == 1) {
            return List.of(matchingComponent);
        }
        for (ComponentNode component1 : matchingComponents) {
            for (ComponentNode component2 : matchingComponents) {
                if (component1 == component2 || component1.getAncestors().contains(component2) || component2.getAncestors().contains(component1)) continue;
                ComponentOverlapping componentOverlapping = this.current.componentOverlaps;
                synchronized (componentOverlapping) {
                    this.current.componentOverlaps.addOverlap(component1, component2, type);
                }
            }
        }
        return List.of(matchingComponent);
    }

    private IdentityHashSet<ComponentNode> getComponentsIncludingType(String type, ListMap<Long, QuickCheckPattern> hashToIncludeLink) {
        IdentityHashSet componentCandidates = new IdentityHashSet();
        for (long hash : QuickCheckPattern.determinePrefixHashes(type)) {
            List quickCheckPatterns = (List)hashToIncludeLink.getCollectionOrEmpty((Object)hash);
            componentCandidates.addAll(this.getComponentsIncludingType(type, quickCheckPatterns));
        }
        return componentCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdentityHashSet<ComponentNode> getComponentsIncludingType(String type, List<QuickCheckPattern> quickCheckPatterns) {
        IdentityHashSet componentCandidates = new IdentityHashSet();
        for (QuickCheckPattern quickCheckPattern : quickCheckPatterns) {
            if (!this.matches(type, quickCheckPattern)) continue;
            ComponentNode component = quickCheckPattern.getComponent();
            if (!this.architecture.isLegacyCodeMapping() && !this.isIncludedInHierarchy(type, component)) continue;
            SetMap<String, String> setMap = this.current.includePatternsToTypes;
            synchronized (setMap) {
                this.current.includePatternsToTypes.add((Object)quickCheckPattern.getPattern(), (Object)type);
            }
            componentCandidates.add((Object)component);
        }
        return componentCandidates;
    }

    private boolean matches(String type, String pattern) {
        return Objects.requireNonNull(QuickCheckPattern.compileAndCachePattern(pattern, this.compiledPatterns)).matcher(type).matches();
    }

    private boolean matches(String type, QuickCheckPattern pattern) {
        return pattern.matchesType(type, this.compiledPatterns);
    }

    private boolean isIncludedInHierarchy(String type, ComponentNode component) {
        for (ComponentNode parent = component.getParent(); parent != null; parent = parent.getParent()) {
            List includePatterns = (List)this.quickCheckIncludePatternsByComponent.getCollectionOrEmpty((Object)parent);
            if (includePatterns.isEmpty() || !includePatterns.stream().noneMatch(includePattern -> this.matches(type, (QuickCheckPattern)includePattern))) continue;
            return false;
        }
        return true;
    }

    private boolean isExplicitlyExcluded(String type, ComponentNode component, IdentityHashSet<ComponentNode> includingComponents, IdentityHashSet<ComponentNode> seenComponents) {
        boolean componentAlreadySeen;
        boolean bl = componentAlreadySeen = !seenComponents.add((Object)component);
        if (componentAlreadySeen) {
            this.logCircularComponentExclusion(seenComponents);
            return false;
        }
        for (CodeMapping mapping : component.getCodeMappings()) {
            ECodeMappingType mappingType = mapping.getType();
            if (mappingType == ECodeMappingType.EXCLUDE && this.matches(type, mapping.getPattern())) {
                return true;
            }
            if (mappingType != ECodeMappingType.EXCLUDE_COMPONENT) continue;
            String excludedComponentName = mapping.getPattern();
            ComponentNode excludedComponent = this.architecture.getComponentByName(excludedComponentName);
            if (excludedComponent == null) {
                LOGGER.warn("Component {} excluded in component {} does not exist in architecture {}", (Object)excludedComponentName, (Object)component.getId(), (Object)this.architecture.getName());
                continue;
            }
            if (!this.isExplicitlyExcludedViaExcludedComponent(type, includingComponents, seenComponents, excludedComponent)) continue;
            return true;
        }
        return this.isExcludedViaHierarchy(type, component, includingComponents, seenComponents);
    }

    private boolean isExcludedViaHierarchy(String type, ComponentNode component, IdentityHashSet<ComponentNode> includingComponents, IdentityHashSet<ComponentNode> seenComponents) {
        return !this.architecture.isLegacyCodeMapping() && component.getParent() != null && this.isExplicitlyExcluded(type, component.getParent(), includingComponents, seenComponents);
    }

    private boolean isExplicitlyExcludedViaExcludedComponent(String type, IdentityHashSet<ComponentNode> includingComponents, IdentityHashSet<ComponentNode> seenComponents, ComponentNode excludedComponent) {
        ArrayList<ComponentNode> componentsToCheck = new ArrayList<ComponentNode>();
        componentsToCheck.add(excludedComponent);
        componentsToCheck.addAll(excludedComponent.getAllSubComponents());
        for (ComponentNode componentToCheck : componentsToCheck) {
            if (!TypeToComponentMapper.containsComponentWithName(includingComponents, componentToCheck.getName()) || this.isExplicitlyExcluded(type, componentToCheck, includingComponents, (IdentityHashSet<ComponentNode>)new IdentityHashSet(seenComponents))) continue;
            return true;
        }
        return false;
    }

    private void logCircularComponentExclusion(IdentityHashSet<ComponentNode> seenComponents) {
        LOGGER.error("Circular component exclusion for components: {} in architecture {}", (Object)CollectionUtils.map(seenComponents, ComponentNode::getName), (Object)this.architecture.getName());
    }

    private static boolean containsComponentWithName(Collection<ComponentNode> components, String name) {
        return components.stream().anyMatch(component -> name.equals(component.getName()));
    }

    public record MappingResult(SetMap<String, ComponentNode> typesToComponents, SetMap<ComponentNode, String> componentsToTypes, Set<String> unmatchedTypes, ListMap<String, String> redundantIncludePatterns, ComponentOverlapping componentOverlaps, ListMap<String, Integer> numberOfMatches, SetMap<String, String> includePatternsToTypes, SetMap<String, String> excludePatternsToTypes) {
        static MappingResult empty() {
            return new MappingResult((SetMap<String, ComponentNode>)new SetMap(), (SetMap<ComponentNode, String>)new SetMap(), new HashSet<String>(), (ListMap<String, String>)new ListMap(), new ComponentOverlapping(), (ListMap<String, Integer>)new ListMap(), (SetMap<String, String>)new SetMap(), (SetMap<String, String>)new SetMap());
        }

        public Optional<ComponentNode> getMappedComponentForType(String type) {
            return this.getMappedComponentsForType(type).stream().min(ComponentNode.BY_DEPTH_DESCENDING);
        }

        public @NonNull Set<ComponentNode> getMappedComponentsForType(String type) {
            return (Set)this.typesToComponents.getCollectionOrEmpty((Object)type);
        }
    }
}

