/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.option.IOption;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.BackupTargetFactory;
import com.teamscale.index.backup.IBackupTarget;
import com.teamscale.index.backup.TemporaryFileIndex;
import java.time.ZonedDateTime;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public abstract class AutoBackupOptionBase
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String TIMESTAMP_PLACEHOLDER = "%t";
    public static final String HOSTNAME_PLACEHOLDER = "%h";
    public static final String PORT_PLACEHOLDER = "%p";
    public static final String INSTANCE_NAME_PLACEHOLDER = "%i";
    public static final String URL_PREFIX_PLACEHOLDER = "%u";
    protected static final String STORAGE_LOCATION_PROPERTY = "storageLocation";
    protected static final String STORAGE_LOCATION_DESCRIPTION = "Full path or URL to store the backup ZIP into. '%t' is replaced by the current date/time stamp. '%h' is replaced by the name of the host machine. '%p' is replaced by the configured HTTPS or HTTP port. '%i' is replaced by the instance name defined in the server configuration (teamscale.properties). '%u' is replaced by the configured URL prefix.";
    private static final String DEFAULT_BACKUP_LOCATION = "backup";

    protected String getStorageLocationDefaultValue() {
        return FileSystemUtils.concatenatePaths((String)DEFAULT_BACKUP_LOCATION, (String[])new String[]{this.determineDefaultFilenamePrefix() + "-%t.zip"});
    }

    protected abstract String determineDefaultFilenamePrefix();

    protected @Nullable String validateStorageLocationContainsPlaceholders(String storageLocation, GlobalStorageSystem globalStorageSystem, InstanceConfiguration instanceConfiguration) {
        String[] split = FileSystemUtils.getPathSegments((String)storageLocation);
        for (int i = 0; i < split.length; ++i) {
            if (!split[i].contains(TIMESTAMP_PLACEHOLDER) || i >= split.length - 1) continue;
            return "Timestamp placeholder of storage location must be within the file name.";
        }
        if (split.length > 0 && StringUtils.splitByWholeSeparator((String)split[split.length - 1], (String)TIMESTAMP_PLACEHOLDER).length > 2) {
            return "Can't use timestamp placeholder twice in file name.";
        }
        BackupLocationInfo backupLocationInfo = new BackupLocationInfo(instanceConfiguration, storageLocation, ZonedDateTime.now());
        String outputUri = backupLocationInfo.getOutputUri();
        try {
            ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class);
            TemporaryFileIndex fileIndex = (TemporaryFileIndex)globalStorageSystem.openGlobalIndex(TemporaryFileIndex.class);
            IBackupTarget target = BackupTargetFactory.getWriteTarget(outputUri, externalCredentialsIndex, fileIndex, LogManager.getLogger(this.getClass()));
            return target.validate();
        }
        catch (StorageException e) {
            return "Validation failed: " + e.getMessage();
        }
    }

    protected static @Nullable String validateStorageLocationIsZipPath(String storageLocation) {
        if (StringUtils.isEmpty((String)storageLocation)) {
            return "Storage location for backup ZIP may not be empty!";
        }
        if (!StringUtils.endsWithIgnoreCase((String)storageLocation, (String)".zip")) {
            return "Storage location must end with '.zip'!";
        }
        return null;
    }

    protected abstract String getStorageLocation();
}

