/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.blacklisting.BranchAgnosticFindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistCommit;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.blacklisting.FindingBlacklistStagingIndex;
import com.teamscale.index.external.update.ExternalUploadPersisterBase;
import com.teamscale.index.repository.ECommitType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class FindingBlacklistChangePersister
extends ExternalUploadPersisterBase<FindingBlacklistCommit> {
    @BranchingLayerAccess(value=FindingBlacklistStagingIndex.class)
    private IBranchingLayer findingBlacklistStagingBranchingLayer;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingBlacklistIndex blacklistIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private BranchAgnosticFindingBlacklistIndex crossBranchBlacklistIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="finding-blacklist-commit-tree")
    private CommitTreeIndex commitTreeIndex;
    @DeltaSource(value=CommitTreeIndex.class, indexName="finding-blacklist-commit-tree")
    private KeyDelta commitTreeDelta;

    @Override
    protected KeyDelta getCommitTreeDelta() {
        return this.commitTreeDelta;
    }

    @Override
    protected void processCommitsForNodes(List<ICommitTreeNode> commitTreeNodes) throws StorageException {
        Set<FindingBlacklistEvent> allEvents = this.collectAllEvents(commitTreeNodes);
        if (allEvents.isEmpty()) {
            return;
        }
        FindingBlacklistEvent event = (FindingBlacklistEvent)CollectionUtils.getAny(allEvents);
        Object commitMessage = event.getCommitMessage();
        if (allEvents.size() > 1) {
            commitMessage = "Finding exclusion state changed for " + allEvents.size() + " findings";
        }
        List<UniformPath> uniformPaths = allEvents.stream().map(FindingBlacklistEvent::getUniformPath).filter(path -> !StringUtils.isEmpty((String)path)).map(UniformPathCompatibilityUtil::convert).collect(Collectors.toList());
        this.writeRepositoryLogEntry(this.getSchedulingCommit(), "finding-blacklisting", (String)commitMessage, event.getUser(), 0, (int)uniformPaths.stream().distinct().count(), 0);
        this.writeRepositoryLogFileEntries(this.getSchedulingCommit(), uniformPaths, Collections.emptyList(), ECommitType.BLACKLIST_COMMIT);
    }

    private Set<FindingBlacklistEvent> collectAllEvents(List<ICommitTreeNode> commitTreeNodes) throws StorageException {
        HashSet<FindingBlacklistEvent> allEvents = new HashSet<FindingBlacklistEvent>();
        for (ICommitTreeNode node : commitTreeNodes) {
            FindingBlacklistCommit blacklistCommit = (FindingBlacklistCommit)((Object)this.getExternalUploadIndex(node).getCommitInfo());
            this.handleBlacklistCommit(blacklistCommit);
            allEvents.addAll((Collection<FindingBlacklistEvent>)blacklistCommit.getBlacklistEvents());
        }
        return allEvents;
    }

    private void handleBlacklistCommit(FindingBlacklistCommit blacklistCommit) throws StorageException {
        block4: for (FindingBlacklistEvent blacklistEvent : blacklistCommit.getBlacklistEvents()) {
            switch (blacklistEvent.getType()) {
                case ADD: {
                    FindingBlacklistInfo blacklistInfo = blacklistEvent.getBlacklistInfo().orElseThrow();
                    this.blacklistIndex.setBlacklistInfos((PairList<String, FindingBlacklistInfo>)PairList.from((Object)blacklistEvent.getFindingId(), (Object)blacklistInfo));
                    this.crossBranchBlacklistIndex.setIfNewer(blacklistInfo);
                    continue block4;
                }
                case REMOVE: {
                    this.blacklistIndex.removeFromBlacklist(blacklistEvent.getFindingId());
                    this.crossBranchBlacklistIndex.removeIfNewer(blacklistEvent.getFindingId(), blacklistCommit.getTimestamp());
                    continue block4;
                }
            }
            CCSMAssert.fail((String)("Unknown flagging event type: " + String.valueOf((Object)blacklistEvent.getType())));
        }
    }

    @Override
    protected IBranchingLayer getExternalUploadBranchingLayer() {
        return this.findingBlacklistStagingBranchingLayer;
    }

    @Override
    protected CommitTreeIndex getCommitTreeIndex() {
        return this.commitTreeIndex;
    }

    @Override
    protected String getRepositoryIdentifier() {
        return "Finding flagging uploads";
    }

    @Override
    protected ECommitType getCommitType() {
        return ECommitType.BLACKLIST_COMMIT;
    }

    protected FindingBlacklistStagingIndex createExternalUploadIndex(IStore store) {
        return new FindingBlacklistStagingIndex(store);
    }
}

